/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.ItemNBTHelper;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class BottledManaItem extends class_1792 {
	public static final int SWIGS = 6;
	private static final String TAG_SWIGS_LEFT = "swigsLeft";
	private static final String TAG_SEED = "randomSeed";

	public BottledManaItem(class_1793 props) {
		super(props);
	}

	private void effect(class_1799 stack, class_1309 living) {
		switch (new Random(getSeed(stack)).nextInt(16)) {
			case 0 -> { // Random motion
				living.method_18800((Math.random() - 0.5) * 3, living.method_18798().method_10214(),
						(Math.random() - 0.5) * 3);
			}
			case 1 -> { // Water
				if (!living.field_6002.field_9236 && !living.field_6002.method_8597().comp_644()) {
					living.field_6002.method_8501(living.method_24515(), class_2246.field_10382.method_9564());
				}
			}
			case 2 -> { // Set on Fire
				if (!living.field_6002.field_9236) {
					living.method_5639(4);
				}
			}
			case 3 -> { // Mini Explosion
				if (!living.field_6002.field_9236) {
					living.field_6002.method_8437(null, living.method_23317(), living.method_23318(),
							living.method_23321(), 0.25F, class_1927.class_4179.field_18685);
				}
			}
			case 4 -> { // Mega Jump
				if (!living.field_6002.method_8597().comp_644()) {
					if (!living.field_6002.field_9236) {
						living.method_6092(new class_1293(class_1294.field_5907, 300, 5));
					}
					living.method_18800(living.method_18798().method_10216(), 6, living.method_18798().method_10215());
				}

			}
			case 5 -> { // Randomly set HP
				if (!living.field_6002.field_9236) {
					float nextHealth = (float) (Math.random() * living.method_6063());
					if (class_3532.method_15347(nextHealth, 0.0F)) {
						nextHealth = 0.5F;
					}
					living.method_6033(nextHealth);
				}
			}
			case 6 -> { // Lots O' Hearts
				if (!living.field_6002.field_9236) {
					living.method_6092(new class_1293(class_1294.field_5898, 20 * 60 * 2, 9));
				}
			}
			case 7 -> { // All your inventory is belong to us
				if (!living.field_6002.field_9236 && living instanceof class_1657 player) {
					player.method_31548().method_7388();
				}

			}
			case 8 -> { // Break your neck
				living.method_36457((float) Math.random() * 360F);
				living.method_36456((float) Math.random() * 180F);

			}
			case 9 -> { // Highest Possible
				int x = class_3532.method_15357(living.method_23317());
				int z = class_3532.method_15357(living.method_23321());
				for (int i = living.field_6002.method_31600(); i > living.field_6002.method_31607(); i--) {
					class_2680 state = living.field_6002.method_8320(new class_2338(x, i, z));
					if (!state.method_26215()) {
						living.method_5859(living.method_23317(), i, living.method_23321());
						break;
					}
				}

			}
			case 10 -> { // HYPERSPEEEEEED
				if (!living.field_6002.field_9236) {
					living.method_6092(new class_1293(class_1294.field_5904, 60, 200));
				}
			}
			case 11 -> { // Night Vision
				if (!living.field_6002.field_9236) {
					living.method_6092(new class_1293(class_1294.field_5925, 6000, 0));
				}
			}
			case 12 -> { // ???
				if (!living.field_6002.field_9236) {
					// todo 1.16 pick something new
				}
			}
			case 13 -> { // Pixie Friend
				if (!living.field_6002.field_9236) {
					PixieEntity pixie = new PixieEntity(living.field_6002);
					pixie.method_5814(living.method_23317(), living.method_23318() + 1.5, living.method_23321());
					living.field_6002.method_8649(pixie);
				}
			}
			case 14 -> { // Nausea + Blindness :3
				if (!living.field_6002.field_9236) {
					living.method_6092(new class_1293(class_1294.field_5916, 160, 3));
					living.method_6092(new class_1293(class_1294.field_5919, 160, 0));
				}

			}
			case 15 -> { // Drop own Head
				if (!living.field_6002.field_9236 && living instanceof class_1657 player) {
					living.method_5643(class_1282.field_5846, living.method_6032() - 1);
					class_1799 skull = new class_1799(class_1802.field_8575);
					ItemNBTHelper.setString(skull, "SkullOwner", player.method_7334().getName());
					living.method_5699(skull, 0);
				}
			}
		}
	}

	private long getSeed(class_1799 stack) {
		long seed = ItemNBTHelper.getLong(stack, TAG_SEED, -1);
		if (seed == -1) {
			return randomSeed(stack);
		}
		return seed;
	}

	private long randomSeed(class_1799 stack) {
		long seed = Math.abs(ThreadLocalRandom.current().nextLong());
		ItemNBTHelper.setLong(stack, TAG_SEED, seed);
		return seed;
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		stacks.add(class_2561.method_43471("botaniamisc.bottleTooltip"));
	}

	@NotNull
	@Override
	public class_1799 method_7861(@NotNull class_1799 stack, class_1937 world, class_1309 living) {
		effect(stack, living);
		int left = getSwigsLeft(stack);
		if (left <= 1) {
			return new class_1799(class_1802.field_8469);
		} else {
			setSwigsLeft(stack, left - 1);
			randomSeed(stack);
			return stack;
		}
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 20;
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8946;
	}

	public static int getSwigsLeft(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, SWIGS);
	}

	private void setSwigsLeft(class_1799 stack, int swigs) {
		ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
	}

}
