/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.client.gui.bag.FlowerPouchContainer;
import vazkii.botania.client.gui.box.BaubleBoxContainer;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.recipe.*;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.brew.IncenseStickItem;
import vazkii.botania.common.item.brew.VialItem;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumBootsItem;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumChestItem;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumHelmItem;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumLegsItem;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelHelmItem;
import vazkii.botania.common.item.equipment.armor.manaweave.ManaweaveArmorItem;
import vazkii.botania.common.item.equipment.armor.manaweave.ManaweaveHelmItem;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelArmorItem;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelHelmItem;
import vazkii.botania.common.item.equipment.bauble.*;
import vazkii.botania.common.item.equipment.tool.SoulscribeItem;
import vazkii.botania.common.item.equipment.tool.StarcallerItem;
import vazkii.botania.common.item.equipment.tool.ThundercallerItem;
import vazkii.botania.common.item.equipment.tool.VitreousPickaxeItem;
import vazkii.botania.common.item.equipment.tool.bow.CrystalBowItem;
import vazkii.botania.common.item.equipment.tool.bow.LivingwoodBowItem;
import vazkii.botania.common.item.equipment.tool.elementium.*;
import vazkii.botania.common.item.equipment.tool.manasteel.*;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraBladeItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;
import vazkii.botania.common.item.lens.*;
import vazkii.botania.common.item.material.*;
import vazkii.botania.common.item.record.BotaniaRecordItem;
import vazkii.botania.common.item.relic.*;
import vazkii.botania.common.item.rod.*;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibItemNames;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4174;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class BotaniaItems {
	private static final Map<class_2960, class_1792> ALL = new LinkedHashMap<>(); // Preserve insertion order
	public static final LexicaBotaniaItem lexicon = make(prefix(LibItemNames.LEXICON), new LexicaBotaniaItem(unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 twigWand = make(prefix(LibItemNames.TWIG_WAND), new WandOfTheForestItem(class_124.field_1077, unstackable().method_7894(class_1814.field_8903)));
	public static final class_1792 dreamwoodWand = make(prefix(LibItemNames.DREAMWOOD_WAND), new WandOfTheForestItem(class_124.field_1076, unstackable().method_7894(class_1814.field_8903)));
	public static final class_1792 obedienceStick = make(prefix(LibItemNames.OBEDIENCE_STICK), new FloralObedienceStickItem(unstackable()));
	public static final class_1792 fertilizer = make(prefix(LibItemNames.FERTILIZER), new FloralFertilizerItem(defaultBuilder()));

	public static final class_1792 whitePetal = make(prefix("white" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7952), class_1767.field_7952, defaultBuilder()));
	public static final class_1792 orangePetal = make(prefix("orange" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7946), class_1767.field_7946, defaultBuilder()));
	public static final class_1792 magentaPetal = make(prefix("magenta" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7958), class_1767.field_7958, defaultBuilder()));
	public static final class_1792 lightBluePetal = make(prefix("light_blue" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7951), class_1767.field_7951, defaultBuilder()));
	public static final class_1792 yellowPetal = make(prefix("yellow" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7947), class_1767.field_7947, defaultBuilder()));
	public static final class_1792 limePetal = make(prefix("lime" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7961), class_1767.field_7961, defaultBuilder()));
	public static final class_1792 pinkPetal = make(prefix("pink" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7954), class_1767.field_7954, defaultBuilder()));
	public static final class_1792 grayPetal = make(prefix("gray" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7944), class_1767.field_7944, defaultBuilder()));
	public static final class_1792 lightGrayPetal = make(prefix("light_gray" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7967), class_1767.field_7967, defaultBuilder()));
	public static final class_1792 cyanPetal = make(prefix("cyan" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7955), class_1767.field_7955, defaultBuilder()));
	public static final class_1792 purplePetal = make(prefix("purple" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7945), class_1767.field_7945, defaultBuilder()));
	public static final class_1792 bluePetal = make(prefix("blue" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7966), class_1767.field_7966, defaultBuilder()));
	public static final class_1792 brownPetal = make(prefix("brown" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7957), class_1767.field_7957, defaultBuilder()));
	public static final class_1792 greenPetal = make(prefix("green" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7942), class_1767.field_7942, defaultBuilder()));
	public static final class_1792 redPetal = make(prefix("red" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7964), class_1767.field_7964, defaultBuilder()));
	public static final class_1792 blackPetal = make(prefix("black" + LibItemNames.PETAL_SUFFIX), new MysticalPetalItem(BotaniaBlocks.getBuriedPetal(class_1767.field_7963), class_1767.field_7963, defaultBuilder()));

	public static final class_1792 manaSteel = make(prefix(LibItemNames.MANASTEEL_INGOT), new class_1792(defaultBuilder()));
	public static final class_1792 manaPearl = make(prefix(LibItemNames.MANA_PEARL), new class_1792(defaultBuilder()));
	public static final class_1792 manaDiamond = make(prefix(LibItemNames.MANA_DIAMOND), new class_1792(defaultBuilder()));
	public static final class_1792 livingwoodTwig = make(prefix(LibItemNames.LIVINGWOOD_TWIG), new BotaniaBannerPatternItem(BotaniaTags.BannerPatterns.PATTERN_ITEM_LIVINGWOOD_TWIG, defaultBuilder()));
	public static final class_1792 terrasteel = make(prefix(LibItemNames.TERRASTEEL_INGOT), new TerrasteelIngotItem(defaultBuilder().method_7894(class_1814.field_8907)));
	public static final class_1792 lifeEssence = make(prefix(LibItemNames.LIFE_ESSENCE), new class_1792(defaultBuilder().method_7894(class_1814.field_8907)));
	public static final class_1792 redstoneRoot = make(prefix(LibItemNames.REDSTONE_ROOT), new class_1792(defaultBuilder()));
	public static final class_1792 elementium = make(prefix(LibItemNames.ELEMENTIUM_INGOT), new class_1792(defaultBuilder()));
	public static final class_1792 pixieDust = make(prefix(LibItemNames.PIXIE_DUST), new class_1792(defaultBuilder()));
	public static final class_1792 dragonstone = make(prefix(LibItemNames.DRAGONSTONE), new class_1792(defaultBuilder()));
	public static final class_1792 redString = make(prefix(LibItemNames.RED_STRING), new class_1792(defaultBuilder()));
	public static final class_1792 dreamwoodTwig = make(prefix(LibItemNames.DREAMWOOD_TWIG), new BotaniaBannerPatternItem(BotaniaTags.BannerPatterns.PATTERN_ITEM_DREAMWOOD_TWIG, defaultBuilder()));
	public static final class_1792 gaiaIngot = make(prefix(LibItemNames.GAIA_INGOT), new ManaResourceItem(defaultBuilder().method_7894(class_1814.field_8903)));
	public static final class_1792 enderAirBottle = make(prefix(LibItemNames.ENDER_AIR_BOTTLE), new EnderAirItem(defaultBuilder()));
	public static final class_1792 manaString = make(prefix(LibItemNames.MANA_STRING), new class_1792(defaultBuilder()));
	public static final class_1792 manasteelNugget = make(prefix(LibItemNames.MANASTEEL_NUGGET), new class_1792(defaultBuilder()));
	public static final class_1792 terrasteelNugget = make(prefix(LibItemNames.TERRASTEEL_NUGGET), new class_1792(defaultBuilder().method_7894(class_1814.field_8907)));
	public static final class_1792 elementiumNugget = make(prefix(LibItemNames.ELEMENTIUM_NUGGET), new class_1792(defaultBuilder()));
	public static final class_1792 livingroot = make(prefix(LibItemNames.LIVING_ROOT), new ManaResourceItem(defaultBuilder()));
	public static final class_1792 pebble = make(prefix(LibItemNames.PEBBLE), new class_1792(defaultBuilder()));
	public static final class_1792 manaweaveCloth = make(prefix(LibItemNames.MANAWEAVE_CLOTH), new class_1792(defaultBuilder()));
	public static final class_1792 manaPowder = make(prefix(LibItemNames.MANA_POWDER), new class_1792(defaultBuilder()));

	public static final class_1792 darkQuartz = make(prefix(LibItemNames.QUARTZ_DARK), new class_1792(defaultBuilder()));
	public static final class_1792 manaQuartz = make(prefix(LibItemNames.QUARTZ_MANA), new class_1792(defaultBuilder()));
	public static final class_1792 blazeQuartz = make(prefix(LibItemNames.QUARTZ_BLAZE), new class_1792(defaultBuilder()));
	public static final class_1792 lavenderQuartz = make(prefix(LibItemNames.QUARTZ_LAVENDER), new class_1792(defaultBuilder()));
	public static final class_1792 redQuartz = make(prefix(LibItemNames.QUARTZ_RED), new class_1792(defaultBuilder()));
	public static final class_1792 elfQuartz = make(prefix(LibItemNames.QUARTZ_ELVEN), new class_1792(defaultBuilder()));
	public static final class_1792 sunnyQuartz = make(prefix(LibItemNames.QUARTZ_SUNNY), new class_1792(defaultBuilder()));

	public static final class_1792 lensNormal = make(prefix(LibItemNames.LENS_NORMAL), new LensItem(stackTo16(), new Lens(), LensItem.PROP_NONE));
	public static final class_1792 lensSpeed = make(prefix(LibItemNames.LENS_SPEED), new LensItem(stackTo16(), new VelocityLens(), LensItem.PROP_NONE));
	public static final class_1792 lensPower = make(prefix(LibItemNames.LENS_POWER), new LensItem(stackTo16(), new PotencyLens(), LensItem.PROP_POWER));
	public static final class_1792 lensTime = make(prefix(LibItemNames.LENS_TIME), new LensItem(stackTo16(), new ResistanceLens(), LensItem.PROP_NONE));
	public static final class_1792 lensEfficiency = make(prefix(LibItemNames.LENS_EFFICIENCY), new LensItem(stackTo16(), new EfficiencyLens(), LensItem.PROP_NONE));
	public static final class_1792 lensBounce = make(prefix(LibItemNames.LENS_BOUNCE), new LensItem(stackTo16(), new BounceLens(), LensItem.PROP_TOUCH));
	public static final class_1792 lensGravity = make(prefix(LibItemNames.LENS_GRAVITY), new LensItem(stackTo16(), new GravityLens(), LensItem.PROP_ORIENTATION));
	public static final class_1792 lensMine = make(prefix(LibItemNames.LENS_MINE), new LensItem(stackTo16(), new BoreLens(), LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensDamage = make(prefix(LibItemNames.LENS_DAMAGE), new LensItem(stackTo16(), new DamagingLens(), LensItem.PROP_DAMAGE));
	public static final class_1792 lensPhantom = make(prefix(LibItemNames.LENS_PHANTOM), new LensItem(stackTo16(), new PhantomLens(), LensItem.PROP_TOUCH));
	public static final class_1792 lensMagnet = make(prefix(LibItemNames.LENS_MAGNET), new LensItem(stackTo16(), new MagnetizingLens(), LensItem.PROP_ORIENTATION));
	public static final class_1792 lensExplosive = make(prefix(LibItemNames.LENS_EXPLOSIVE), new LensItem(stackTo16(), new EntropicLens(), LensItem.PROP_DAMAGE | LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensInfluence = make(prefix(LibItemNames.LENS_INFLUENCE), new LensItem(stackTo16(), new InfluenceLens(), LensItem.PROP_NONE));
	public static final class_1792 lensWeight = make(prefix(LibItemNames.LENS_WEIGHT), new LensItem(stackTo16(), new WeightLens(), LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensPaint = make(prefix(LibItemNames.LENS_PAINT), new LensItem(stackTo16(), new PaintslingerLens(), LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensFire = make(prefix(LibItemNames.LENS_FIRE), new LensItem(stackTo16(), new KindleLens(), LensItem.PROP_DAMAGE | LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensPiston = make(prefix(LibItemNames.LENS_PISTON), new LensItem(stackTo16(), new ForceLens(), LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensLight = make(prefix(LibItemNames.LENS_LIGHT), new LensItem(stackTo16(), new FlashLens(), LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensWarp = make(prefix(LibItemNames.LENS_WARP), new LensItem(stackTo16(), new WarpLens(), LensItem.PROP_NONE));
	public static final class_1792 lensRedirect = make(prefix(LibItemNames.LENS_REDIRECT), new LensItem(stackTo16(), new RedirectiveLens(), LensItem.PROP_TOUCH | LensItem.PROP_INTERACTION));
	public static final class_1792 lensFirework = make(prefix(LibItemNames.LENS_FIREWORK), new LensItem(stackTo16(), new CelebratoryLens(), LensItem.PROP_TOUCH));
	public static final class_1792 lensFlare = make(prefix(LibItemNames.LENS_FLARE), new LensItem(stackTo16(), new FlareLens(), LensItem.PROP_CONTROL));
	public static final class_1792 lensMessenger = make(prefix(LibItemNames.LENS_MESSENGER), new LensItem(stackTo16(), new MessengerLens(), LensItem.PROP_POWER));
	public static final class_1792 lensTripwire = make(prefix(LibItemNames.LENS_TRIPWIRE), new LensItem(stackTo16(), new TripwireLens(), LensItem.PROP_CONTROL));
	public static final class_1792 lensStorm = make(prefix(LibItemNames.LENS_STORM), new LensItem(stackTo16().method_7894(class_1814.field_8904), new StormLens(), LensItem.PROP_NONE));

	public static final class_1792 runeWater = make(prefix(LibItemNames.RUNE_WATER), new RuneItem(defaultBuilder()));
	public static final class_1792 runeFire = make(prefix(LibItemNames.RUNE_FIRE), new RuneItem(defaultBuilder()));
	public static final class_1792 runeEarth = make(prefix(LibItemNames.RUNE_EARTH), new RuneItem(defaultBuilder()));
	public static final class_1792 runeAir = make(prefix(LibItemNames.RUNE_AIR), new RuneItem(defaultBuilder()));
	public static final class_1792 runeSpring = make(prefix(LibItemNames.RUNE_SPRING), new RuneItem(defaultBuilder()));
	public static final class_1792 runeSummer = make(prefix(LibItemNames.RUNE_SUMMER), new RuneItem(defaultBuilder()));
	public static final class_1792 runeAutumn = make(prefix(LibItemNames.RUNE_AUTUMN), new RuneItem(defaultBuilder()));
	public static final class_1792 runeWinter = make(prefix(LibItemNames.RUNE_WINTER), new RuneItem(defaultBuilder()));
	public static final class_1792 runeMana = make(prefix(LibItemNames.RUNE_MANA), new RuneItem(defaultBuilder()));
	public static final class_1792 runeLust = make(prefix(LibItemNames.RUNE_LUST), new RuneItem(defaultBuilder()));
	public static final class_1792 runeGluttony = make(prefix(LibItemNames.RUNE_GLUTTONY), new RuneItem(defaultBuilder()));
	public static final class_1792 runeGreed = make(prefix(LibItemNames.RUNE_GREED), new RuneItem(defaultBuilder()));
	public static final class_1792 runeSloth = make(prefix(LibItemNames.RUNE_SLOTH), new RuneItem(defaultBuilder()));
	public static final class_1792 runeWrath = make(prefix(LibItemNames.RUNE_WRATH), new RuneItem(defaultBuilder()));
	public static final class_1792 runeEnvy = make(prefix(LibItemNames.RUNE_ENVY), new RuneItem(defaultBuilder()));
	public static final class_1792 runePride = make(prefix(LibItemNames.RUNE_PRIDE), new RuneItem(defaultBuilder()));

	public static final class_1792 grassSeeds = make(prefix(LibItemNames.GRASS_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.GRASS, defaultBuilder()));
	public static final class_1792 podzolSeeds = make(prefix(LibItemNames.PODZOL_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.PODZOL, defaultBuilder()));
	public static final class_1792 mycelSeeds = make(prefix(LibItemNames.MYCEL_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.MYCEL, defaultBuilder()));
	public static final class_1792 drySeeds = make(prefix(LibItemNames.DRY_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.DRY, defaultBuilder()));
	public static final class_1792 goldenSeeds = make(prefix(LibItemNames.GOLDEN_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.GOLDEN, defaultBuilder()));
	public static final class_1792 vividSeeds = make(prefix(LibItemNames.VIVID_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.VIVID, defaultBuilder()));
	public static final class_1792 scorchedSeeds = make(prefix(LibItemNames.SCORCHED_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.SCORCHED, defaultBuilder()));
	public static final class_1792 infusedSeeds = make(prefix(LibItemNames.INFUSED_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.INFUSED, defaultBuilder()));
	public static final class_1792 mutatedSeeds = make(prefix(LibItemNames.MUTATED_SEEDS), new GrassSeedsItem(FloatingFlower.IslandType.MUTATED, defaultBuilder()));

	public static final class_1792 dirtRod = make(prefix(LibItemNames.DIRT_ROD), new LandsRodItem(unstackable()));
	public static final class_1792 skyDirtRod = make(prefix(LibItemNames.SKY_DIRT_ROD), new HighlandsRodItem(unstackable()));
	public static final class_1792 terraformRod = make(prefix(LibItemNames.TERRAFORM_ROD), new TerraFirmaRodItem(unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 cobbleRod = make(prefix(LibItemNames.COBBLE_ROD), new DepthsRodItem(unstackable()));
	public static final class_1792 waterRod = make(prefix(LibItemNames.WATER_ROD), new SeasRodItem(unstackable()));
	public static final class_1792 tornadoRod = make(prefix(LibItemNames.TORNADO_ROD), new SkiesRodItem(unstackable()));
	public static final class_1792 fireRod = make(prefix(LibItemNames.FIRE_ROD), new HellsRodItem(unstackable()));
	public static final class_1792 diviningRod = make(prefix(LibItemNames.DIVINING_ROD), new PlentifulMantleRodItem(unstackable()));
	public static final class_1792 smeltRod = make(prefix(LibItemNames.SMELT_ROD), new MoltenCoreRodItem(unstackable()));
	public static final class_1792 exchangeRod = make(prefix(LibItemNames.EXCHANGE_ROD), new ShiftingCrustRodItem(unstackable()));
	public static final class_1792 rainbowRod = make(prefix(LibItemNames.RAINBOW_ROD), new BifrostRodItem(unstackable()));
	public static final class_1792 gravityRod = make(prefix(LibItemNames.GRAVITY_ROD), new ShadedMesaRodItem(unstackable()));
	public static final class_1792 missileRod = make(prefix(LibItemNames.MISSILE_ROD), new UnstableReservoirRodItem(unstackable().method_7894(class_1814.field_8907)));

	// Equipment
	public static final class_1792 manasteelHelm = make(prefix(LibItemNames.MANASTEEL_HELM), new ManasteelHelmItem(unstackableCustomDamage()));
	public static final class_1792 manasteelChest = make(prefix(LibItemNames.MANASTEEL_CHEST), new ManasteelArmorItem(class_1304.field_6174, unstackableCustomDamage()));
	public static final class_1792 manasteelLegs = make(prefix(LibItemNames.MANASTEEL_LEGS), new ManasteelArmorItem(class_1304.field_6172, unstackableCustomDamage()));
	public static final class_1792 manasteelBoots = make(prefix(LibItemNames.MANASTEEL_BOOTS), new ManasteelArmorItem(class_1304.field_6166, unstackableCustomDamage()));
	public static final class_1792 manasteelPick = make(prefix(LibItemNames.MANASTEEL_PICK), new ManasteelPickaxeItem(unstackableCustomDamage()));
	public static final class_1792 manasteelShovel = make(prefix(LibItemNames.MANASTEEL_SHOVEL), new ManasteelShovelItem(unstackableCustomDamage()));
	public static final class_1792 manasteelAxe = make(prefix(LibItemNames.MANASTEEL_AXE), new ManasteelAxeItem(unstackableCustomDamage()));
	public static final class_1792 manasteelHoe = make(prefix(LibItemNames.MANASTEEL_HOE), new ManasteelHoeItem(unstackableCustomDamage()));
	public static final class_1792 manasteelSword = make(prefix(LibItemNames.MANASTEEL_SWORD), new ManasteelSwordItem(unstackableCustomDamage()));
	public static final class_1792 manasteelShears = make(prefix(LibItemNames.MANASTEEL_SHEARS), new ManasteelShearsItem(unstackableCustomDamage().method_7898(238)));
	public static final class_1792 elementiumHelm = make(prefix(LibItemNames.ELEMENTIUM_HELM), new ElementiumHelmItem(unstackableCustomDamage()));
	public static final class_1792 elementiumChest = make(prefix(LibItemNames.ELEMENTIUM_CHEST), new ElementiumChestItem(unstackableCustomDamage()));
	public static final class_1792 elementiumLegs = make(prefix(LibItemNames.ELEMENTIUM_LEGS), new ElementiumLegsItem(unstackableCustomDamage()));
	public static final class_1792 elementiumBoots = make(prefix(LibItemNames.ELEMENTIUM_BOOTS), new ElementiumBootsItem(unstackableCustomDamage()));
	public static final class_1792 elementiumPick = make(prefix(LibItemNames.ELEMENTIUM_PICK), new ElementiumPickaxeItem(unstackableCustomDamage()));
	public static final class_1792 elementiumShovel = make(prefix(LibItemNames.ELEMENTIUM_SHOVEL), new ElementiumShovelItem(unstackableCustomDamage()));
	public static final class_1792 elementiumAxe = make(prefix(LibItemNames.ELEMENTIUM_AXE), new ElementiumAxeItem(unstackableCustomDamage()));
	public static final class_1792 elementiumHoe = make(prefix(LibItemNames.ELEMENTIUM_HOE), new ElementiumHoeItem(unstackableCustomDamage()));
	public static final class_1792 elementiumSword = make(prefix(LibItemNames.ELEMENTIUM_SWORD), new ElementiumSwordItem(unstackableCustomDamage()));
	public static final class_1792 elementiumShears = make(prefix(LibItemNames.ELEMENTIUM_SHEARS), new ElementiumShearsItem(unstackableCustomDamage().method_7898(238)));
	public static final class_1792 terrasteelHelm = make(prefix(LibItemNames.TERRASTEEL_HELM), new TerrasteelHelmItem(unstackableCustomDamage().method_24359().method_7894(class_1814.field_8907)));
	public static final class_1792 terrasteelChest = make(prefix(LibItemNames.TERRASTEEL_CHEST), new TerrasteelArmorItem(class_1304.field_6174, unstackableCustomDamage().method_24359().method_7894(class_1814.field_8907)));
	public static final class_1792 terrasteelLegs = make(prefix(LibItemNames.TERRASTEEL_LEGS), new TerrasteelArmorItem(class_1304.field_6172, unstackableCustomDamage().method_24359().method_7894(class_1814.field_8907)));
	public static final class_1792 terrasteelBoots = make(prefix(LibItemNames.TERRASTEEL_BOOTS), new TerrasteelArmorItem(class_1304.field_6166, unstackableCustomDamage().method_24359().method_7894(class_1814.field_8907)));
	public static final class_1792 terraPick = make(prefix(LibItemNames.TERRA_PICK), new TerraShattererItem(unstackableCustomDamage().method_24359().method_7894(class_1814.field_8907)));
	public static final class_1792 terraAxe = make(prefix(LibItemNames.TERRA_AXE), new TerraTruncatorItem(unstackableCustomDamage().method_24359().method_7894(class_1814.field_8907)));
	public static final class_1792 terraSword = make(prefix(LibItemNames.TERRA_SWORD), new TerraBladeItem(unstackableCustomDamage().method_24359().method_7894(class_1814.field_8907)));
	public static final class_1792 starSword = make(prefix(LibItemNames.STAR_SWORD), new StarcallerItem(unstackableCustomDamage().method_7894(class_1814.field_8907)));
	public static final class_1792 thunderSword = make(prefix(LibItemNames.THUNDER_SWORD), new ThundercallerItem(unstackableCustomDamage().method_7894(class_1814.field_8907)));
	public static final class_1792 manaweaveHelm = make(prefix(LibItemNames.MANAWEAVE_HELM), new ManaweaveHelmItem(unstackableCustomDamage()));
	public static final class_1792 manaweaveChest = make(prefix(LibItemNames.MANAWEAVE_CHEST), new ManaweaveArmorItem(class_1304.field_6174, unstackableCustomDamage()));
	public static final class_1792 manaweaveLegs = make(prefix(LibItemNames.MANAWEAVE_LEGS), new ManaweaveArmorItem(class_1304.field_6172, unstackableCustomDamage()));
	public static final class_1792 manaweaveBoots = make(prefix(LibItemNames.MANAWEAVE_BOOTS), new ManaweaveArmorItem(class_1304.field_6166, unstackableCustomDamage()));
	public static final class_1792 enderDagger = make(prefix(LibItemNames.ENDER_DAGGER), new SoulscribeItem(unstackable().method_7898(69))); // What you looking at?
	public static final class_1792 glassPick = make(prefix(LibItemNames.GLASS_PICK), new VitreousPickaxeItem(unstackableCustomDamage()));
	public static final class_1792 livingwoodBow = make(prefix(LibItemNames.LIVINGWOOD_BOW), new LivingwoodBowItem(defaultBuilderCustomDamage().method_7898(500)));
	public static final class_1792 crystalBow = make(prefix(LibItemNames.CRYSTAL_BOW), new CrystalBowItem(defaultBuilderCustomDamage().method_7898(500)));
	public static final class_1792 thornChakram = make(prefix(LibItemNames.THORN_CHAKRAM), new ThornChakramItem(defaultBuilder().method_7889(6)));
	public static final class_1792 flareChakram = make(prefix(LibItemNames.FLARE_CHAKRAM), new ThornChakramItem(defaultBuilder().method_7889(6)));

	// Misc tools
	public static final class_1792 manaTablet = make(prefix(LibItemNames.MANA_TABLET), new ManaTabletItem(unstackable()));
	public static final class_1792 manaMirror = make(prefix(LibItemNames.MANA_MIRROR), new ManaMirrorItem(unstackable()));
	public static final class_1792 manaGun = make(prefix(LibItemNames.MANA_GUN), new ManaBlasterItem(unstackable()));
	public static final class_1792 clip = make(prefix(LibItemNames.CLIP), new class_1792(unstackable()));
	public static final class_1792 grassHorn = make(prefix(LibItemNames.GRASS_HORN), new HornItem(unstackable()));
	public static final class_1792 leavesHorn = make(prefix(LibItemNames.LEAVES_HORN), new HornItem(unstackable()));
	public static final class_1792 snowHorn = make(prefix(LibItemNames.SNOW_HORN), new HornItem(unstackable()));
	public static final class_1792 vineBall = make(prefix(LibItemNames.VINE_BALL), new VineBallItem(defaultBuilder()));
	public static final class_1792 slingshot = make(prefix(LibItemNames.SLINGSHOT), new LivingwoodSlingshotItem(unstackable()));
	public static final class_1792 openBucket = make(prefix(LibItemNames.OPEN_BUCKET), new ExtrapolatedBucketItem(unstackable()));
	public static final class_1792 spawnerMover = make(prefix(LibItemNames.SPAWNER_MOVER), new LifeAggregatorItem(unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 enderHand = make(prefix(LibItemNames.ENDER_HAND), new EnderHandItem(unstackable()));
	public static final class_1792 craftingHalo = make(prefix(LibItemNames.CRAFTING_HALO), new AssemblyHaloItem(unstackable()));
	public static final class_1792 autocraftingHalo = make(prefix(LibItemNames.AUTOCRAFTING_HALO), new ManufactoryHaloItem(unstackable()));
	public static final class_1792 spellCloth = make(prefix(LibItemNames.SPELL_CLOTH), new SpellbindingClothItem(XplatAbstractions.INSTANCE.noRepairOnForge(unstackable().method_7898(35))));
	public static final class_1792 flowerBag = make(prefix(LibItemNames.FLOWER_BAG), new FlowerPouchItem(unstackable()));
	public static final class_1792 blackHoleTalisman = make(prefix(LibItemNames.BLACK_HOLE_TALISMAN), new BlackHoleTalismanItem(unstackable()));
	public static final class_1792 temperanceStone = make(prefix(LibItemNames.TEMPERANCE_STONE), new StoneOfTemperanceItem(unstackable()));
	public static final class_1792 waterBowl = make(prefix(LibItemNames.WATER_BOWL), new WaterBowlItem(unstackable()));
	public static final class_1792 cacophonium = make(prefix(LibItemNames.CACOPHONIUM), new CacophoniumItem(unstackable()));
	public static final class_1792 slimeBottle = make(prefix(LibItemNames.SLIME_BOTTLE), new SlimeInABottleItem(unstackable()));
	public static final class_1792 sextant = make(prefix(LibItemNames.SEXTANT), new WorldshaperssSextantItem(unstackable()));
	public static final class_1792 astrolabe = make(prefix(LibItemNames.ASTROLABE), new AstrolabeItem(unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 baubleBox = make(prefix(LibItemNames.BAUBLE_BOX), new BaubleBoxItem(unstackable()));

	// Baubles / trinkets / curios / etc.
	public static final class_1792 manaRing = make(prefix(LibItemNames.MANA_RING), new BandOfManaItem(unstackable()));
	public static final class_1792 manaRingGreater = make(prefix(LibItemNames.MANA_RING_GREATER), new GreaterBandOfManaItem(unstackable()));
	public static final class_1792 auraRing = make(prefix(LibItemNames.AURA_RING), new BandOfAuraItem(unstackable(), 10));
	public static final class_1792 auraRingGreater = make(prefix(LibItemNames.AURA_RING_GREATER), new BandOfAuraItem(unstackable(), 2));
	public static final class_1792 magnetRing = make(prefix(LibItemNames.MAGNET_RING), new RingOfMagnetizationItem(unstackable()));
	public static final class_1792 magnetRingGreater = make(prefix(LibItemNames.MAGNET_RING_GREATER), new RingOfMagnetizationItem(unstackable(), 16));
	public static final class_1792 waterRing = make(prefix(LibItemNames.WATER_RING), new RingOfChordataItem(unstackable().method_7894(class_1814.field_8903)));
	public static final class_1792 swapRing = make(prefix(LibItemNames.SWAP_RING), new RingOfCorrectionItem(unstackable()));
	public static final class_1792 dodgeRing = make(prefix(LibItemNames.DODGE_RING), new RingOfDexterousMotionItem(unstackable()));
	public static final class_1792 miningRing = make(prefix(LibItemNames.MINING_RING), new RingOfTheMantleItem(unstackable()));
	public static final class_1792 pixieRing = make(prefix(LibItemNames.PIXIE_RING), new GreatFairyRingItem(unstackable()));
	public static final class_1792 reachRing = make(prefix(LibItemNames.REACH_RING), new RingOfFarReachItem(unstackable()));
	public static final class_1792 travelBelt = make(prefix(LibItemNames.TRAVEL_BELT), new SojournersSashItem(unstackable()));
	public static final class_1792 superTravelBelt = make(prefix(LibItemNames.SUPER_TRAVEL_BELT), new GlobetrottersSashItem(unstackable()));
	public static final class_1792 speedUpBelt = make(prefix(LibItemNames.SPEED_UP_BELT), new PlanestridersSashItem(unstackable()));
	public static final class_1792 knockbackBelt = make(prefix(LibItemNames.KNOCKBACK_BELT), new TectonicGirdleItem(unstackable()));
	public static final class_1792 icePendant = make(prefix(LibItemNames.ICE_PENDANT), new SnowflakePendantItem(unstackable()));
	public static final class_1792 lavaPendant = make(prefix(LibItemNames.LAVA_PENDANT), new PyroclastPendantItem(unstackable()));
	public static final class_1792 superLavaPendant = make(prefix(LibItemNames.SUPER_LAVA_PENDANT), new CrimsonPendantItem(unstackable()));
	public static final class_1792 cloudPendant = make(prefix(LibItemNames.CLOUD_PENDANT), new CirrusAmuletItem(unstackable()));
	public static final class_1792 superCloudPendant = make(prefix(LibItemNames.SUPER_CLOUD_PENDANT), new NimbusAmuletItem(unstackable()));
	public static final class_1792 holyCloak = make(prefix(LibItemNames.HOLY_CLOAK), new CloakOfVirtueItem(unstackable()));
	public static final class_1792 unholyCloak = make(prefix(LibItemNames.UNHOLY_CLOAK), new CloakOfSinItem(unstackable()));
	public static final class_1792 balanceCloak = make(prefix(LibItemNames.BALANCE_CLOAK), new CloakOfBalanceItem(unstackable()));
	public static final class_1792 invisibilityCloak = make(prefix(LibItemNames.INVISIBILITY_CLOAK), new InvisibilityCloakItem(unstackable()));
	public static final class_1792 thirdEye = make(prefix(LibItemNames.THIRD_EYE), new ThirdEyeItem(unstackable()));
	public static final class_1792 monocle = make(prefix(LibItemNames.MONOCLE), new ManaseerMonocleItem(unstackable()));
	public static final class_1792 tinyPlanet = make(prefix(LibItemNames.TINY_PLANET), new TinyPlanetItem(unstackable()));
	public static final class_1792 goddessCharm = make(prefix(LibItemNames.GODDESS_CHARM), new BenevolentGoddessCharmItem(unstackable()));
	public static final class_1792 divaCharm = make(prefix(LibItemNames.DIVA_CHARM), new CharmOfTheDivaItem(unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 itemFinder = make(prefix(LibItemNames.ITEM_FINDER), new SpectatorItem(unstackable()));
	public static final class_1792 flightTiara = make(prefix(LibItemNames.FLIGHT_TIARA), new FlugelTiaraItem(unstackable().method_7894(class_1814.field_8907)));

	// Misc
	public static final class_1792 manaCookie = make(prefix(LibItemNames.MANA_COOKIE), new class_1792(defaultBuilder().method_19265(new class_4174.class_4175().method_19238(0).method_19237(0.1F).method_19239(new class_1293(class_1294.field_5922, 20, 0), 1).method_19242())));
	public static final class_1792 manaBottle = make(prefix(LibItemNames.MANA_BOTTLE), new BottledManaItem(
			// Mark as food just to fool foxes into using it
			unstackable().method_19265(new class_4174.class_4175().method_19240().method_19242())));
	public static final class_1792 laputaShard = make(prefix(LibItemNames.LAPUTA_SHARD), new LaputaShardItem(unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 necroVirus = make(prefix(LibItemNames.NECRO_VIRUS), new EquestrianVirusItem(defaultBuilder()));
	public static final class_1792 nullVirus = make(prefix(LibItemNames.NULL_VIRUS), new EquestrianVirusItem(defaultBuilder()));
	public static final class_1792 spark = make(prefix(LibItemNames.SPARK), new ManaSparkItem(defaultBuilder()));
	public static final class_1792 sparkUpgradeDispersive = make(prefix(LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.DISPERSIVE.name().toLowerCase(Locale.ROOT)), new SparkAugmentItem(defaultBuilder(), SparkUpgradeType.DISPERSIVE));
	public static final class_1792 sparkUpgradeDominant = make(prefix(LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.DOMINANT.name().toLowerCase(Locale.ROOT)), new SparkAugmentItem(defaultBuilder(), SparkUpgradeType.DOMINANT));
	public static final class_1792 sparkUpgradeRecessive = make(prefix(LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.RECESSIVE.name().toLowerCase(Locale.ROOT)), new SparkAugmentItem(defaultBuilder(), SparkUpgradeType.RECESSIVE));
	public static final class_1792 sparkUpgradeIsolated = make(prefix(LibItemNames.SPARK_UPGRADE + "_" + SparkUpgradeType.ISOLATED.name().toLowerCase(Locale.ROOT)), new SparkAugmentItem(defaultBuilder(), SparkUpgradeType.ISOLATED));
	public static final class_1792 corporeaSpark = make(prefix(LibItemNames.CORPOREA_SPARK), new CorporeaSparkItem(defaultBuilder()));
	public static final class_1792 corporeaSparkMaster = make(prefix(LibItemNames.CORPOREA_SPARK_MASTER), new CorporeaSparkItem(defaultBuilder()));
	public static final class_1792 corporeaSparkCreative = make(prefix(LibItemNames.CORPOREA_SPARK_CREATIVE), new CorporeaSparkItem(defaultBuilder().method_7894(class_1814.field_8904)));
	public static final class_1792 blackLotus = make(prefix(LibItemNames.BLACK_LOTUS), new BlackLotusItem(defaultBuilder().method_7894(class_1814.field_8903)));
	public static final class_1792 blackerLotus = make(prefix(LibItemNames.BLACKER_LOTUS), new BlackLotusItem(defaultBuilder().method_7894(class_1814.field_8904)));
	public static final class_1792 worldSeed = make(prefix(LibItemNames.WORLD_SEED), new WorldSeedItem(defaultBuilder()));
	public static final class_1792 overgrowthSeed = make(prefix(LibItemNames.OVERGROWTH_SEED), new OvergrowthSeedItem(defaultBuilder().method_7894(class_1814.field_8903)));
	public static final class_1792 phantomInk = make(prefix(LibItemNames.PHANTOM_INK), new class_1792(defaultBuilder()));
	public static final class_1792 poolMinecart = make(prefix(LibItemNames.POOL_MINECART), new ManaPoolMinecartItem(unstackable()));
	public static final class_1792 keepIvy = make(prefix(LibItemNames.KEEP_IVY), new ResoluteIvyItem(defaultBuilder()));
	public static final class_1792 placeholder = make(prefix(LibItemNames.PLACEHOLDER), new SelfReturningItem(defaultBuilder()));
	public static final class_1792 craftPattern1_1 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "1_1"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_1_1, unstackable()));
	public static final class_1792 craftPattern2_2 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "2_2"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_2_2, unstackable()));
	public static final class_1792 craftPattern1_2 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "1_2"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_1_2, unstackable()));
	public static final class_1792 craftPattern2_1 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "2_1"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_2_1, unstackable()));
	public static final class_1792 craftPattern1_3 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "1_3"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_1_3, unstackable()));
	public static final class_1792 craftPattern3_1 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "3_1"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_3_1, unstackable()));
	public static final class_1792 craftPattern2_3 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "2_3"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_2_3, unstackable()));
	public static final class_1792 craftPattern3_2 = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "3_2"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_3_2, unstackable()));
	public static final class_1792 craftPatternDonut = make(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + "donut"), new CraftingPatternItem(CraftyCratePattern.CRAFTY_DONUT, unstackable()));

	// Guardian of Gaia drops
	public static final class_1792 dice = make(prefix(LibItemNames.DICE), new DiceOfFateItem(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity())));
	public static final class_1792 infiniteFruit = make(prefix(LibItemNames.INFINITE_FRUIT), new FruitOfGrisaiaItem(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity())));
	public static final class_1792 kingKey = make(prefix(LibItemNames.KING_KEY), new KeyOfTheKingsLawItem(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity())));
	public static final class_1792 flugelEye = make(prefix(LibItemNames.FLUGEL_EYE), new EyeOfTheFlugelItem(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity())));
	public static final class_1792 thorRing = make(prefix(LibItemNames.THOR_RING), new RingOfThorItem(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity())));
	public static final class_1792 odinRing = make(prefix(LibItemNames.ODIN_RING), new RingOfOdinItem(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity())));
	public static final class_1792 lokiRing = make(prefix(LibItemNames.LOKI_RING), new RingOfLokiItem(unstackable().method_24359().method_7894(BotaniaAPI.instance().getRelicRarity())));
	public static final class_1792 recordGaia1 = make(prefix(LibItemNames.RECORD_GAIA1), new BotaniaRecordItem(1, BotaniaSounds.gaiaMusic1, unstackable().method_7894(class_1814.field_8903), 202));
	public static final class_1792 recordGaia2 = make(prefix(LibItemNames.RECORD_GAIA2), new BotaniaRecordItem(1, BotaniaSounds.gaiaMusic2, unstackable().method_7894(class_1814.field_8903), 227));
	public static final class_1792 ancientWillAhrim = make(prefix(LibItemNames.ANCIENT_WILL_PREFIX + "ahrim"), new AncientWillItem(AncientWillContainer.AncientWillType.AHRIM, unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 ancientWillDharok = make(prefix(LibItemNames.ANCIENT_WILL_PREFIX + "dharok"), new AncientWillItem(AncientWillContainer.AncientWillType.DHAROK, unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 ancientWillGuthan = make(prefix(LibItemNames.ANCIENT_WILL_PREFIX + "guthan"), new AncientWillItem(AncientWillContainer.AncientWillType.GUTHAN, unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 ancientWillTorag = make(prefix(LibItemNames.ANCIENT_WILL_PREFIX + "torag"), new AncientWillItem(AncientWillContainer.AncientWillType.TORAG, unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 ancientWillVerac = make(prefix(LibItemNames.ANCIENT_WILL_PREFIX + "verac"), new AncientWillItem(AncientWillContainer.AncientWillType.VERAC, unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 ancientWillKaril = make(prefix(LibItemNames.ANCIENT_WILL_PREFIX + "karil"), new AncientWillItem(AncientWillContainer.AncientWillType.KARIL, unstackable().method_7894(class_1814.field_8907)));
	public static final class_1792 pinkinator = make(prefix(LibItemNames.PINKINATOR), new PinkinatorItem(unstackable().method_7894(class_1814.field_8907)));

	// Brewing
	public static final class_1792 vial = make(prefix(LibItemNames.VIAL), new VialItem(defaultBuilder()));
	public static final class_1792 flask = make(prefix(LibItemNames.FLASK), new VialItem(defaultBuilder()));
	public static final class_1792 brewVial = make(prefix(LibItemNames.BREW_VIAL), new BaseBrewItem(unstackable(), 4, 32, () -> vial));
	public static final class_1792 brewFlask = make(prefix(LibItemNames.BREW_FLASK), new BaseBrewItem(unstackable(), 6, 24, () -> flask));
	public static final class_1792 bloodPendant = make(prefix(LibItemNames.BLOOD_PENDANT), new TaintedBloodPendantItem(unstackable()));
	public static final class_1792 incenseStick = make(prefix(LibItemNames.INCENSE_STICK), new IncenseStickItem(unstackable()));

	// Cosmetics
	public static final class_1792 blackBowtie = make(prefix(LibItemNames.COSMETIC_PREFIX + "black_bowtie"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.BLACK_BOWTIE, unstackable()));
	public static final class_1792 blackTie = make(prefix(LibItemNames.COSMETIC_PREFIX + "black_tie"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.BLACK_TIE, unstackable()));
	public static final class_1792 redGlasses = make(prefix(LibItemNames.COSMETIC_PREFIX + "red_glasses"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.RED_GLASSES, unstackable()));
	public static final class_1792 puffyScarf = make(prefix(LibItemNames.COSMETIC_PREFIX + "puffy_scarf"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.PUFFY_SCARF, unstackable()));
	public static final class_1792 engineerGoggles = make(prefix(LibItemNames.COSMETIC_PREFIX + "engineer_goggles"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.ENGINEER_GOGGLES, unstackable()));
	public static final class_1792 eyepatch = make(prefix(LibItemNames.COSMETIC_PREFIX + "eyepatch"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.EYEPATCH, unstackable()));
	public static final class_1792 wickedEyepatch = make(prefix(LibItemNames.COSMETIC_PREFIX + "wicked_eyepatch"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.WICKED_EYEPATCH, unstackable()));
	public static final class_1792 redRibbons = make(prefix(LibItemNames.COSMETIC_PREFIX + "red_ribbons"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.RED_RIBBONS, unstackable()));
	public static final class_1792 pinkFlowerBud = make(prefix(LibItemNames.COSMETIC_PREFIX + "pink_flower_bud"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.PINK_FLOWER_BUD, unstackable()));
	public static final class_1792 polkaDottedBows = make(prefix(LibItemNames.COSMETIC_PREFIX + "polka_dotted_bows"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.POLKA_DOTTED_BOWS, unstackable()));
	public static final class_1792 blueButterfly = make(prefix(LibItemNames.COSMETIC_PREFIX + "blue_butterfly"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.BLUE_BUTTERFLY, unstackable()));
	public static final class_1792 catEars = make(prefix(LibItemNames.COSMETIC_PREFIX + "cat_ears"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.CAT_EARS, unstackable()));
	public static final class_1792 witchPin = make(prefix(LibItemNames.COSMETIC_PREFIX + "witch_pin"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.WITCH_PIN, unstackable()));
	public static final class_1792 devilTail = make(prefix(LibItemNames.COSMETIC_PREFIX + "devil_tail"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.DEVIL_TAIL, unstackable()));
	public static final class_1792 kamuiEye = make(prefix(LibItemNames.COSMETIC_PREFIX + "kamui_eye"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.KAMUI_EYE, unstackable()));
	public static final class_1792 googlyEyes = make(prefix(LibItemNames.COSMETIC_PREFIX + "googly_eyes"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.GOOGLY_EYES, unstackable()));
	public static final class_1792 fourLeafClover = make(prefix(LibItemNames.COSMETIC_PREFIX + "four_leaf_clover"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.FOUR_LEAF_CLOVER, unstackable()));
	public static final class_1792 clockEye = make(prefix(LibItemNames.COSMETIC_PREFIX + "clock_eye"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.CLOCK_EYE, unstackable()));
	public static final class_1792 unicornHorn = make(prefix(LibItemNames.COSMETIC_PREFIX + "unicorn_horn"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.UNICORN_HORN, unstackable()));
	public static final class_1792 devilHorns = make(prefix(LibItemNames.COSMETIC_PREFIX + "devil_horns"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.DEVIL_HORNS, unstackable()));
	public static final class_1792 hyperPlus = make(prefix(LibItemNames.COSMETIC_PREFIX + "hyper_plus"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.HYPER_PLUS, unstackable()));
	public static final class_1792 botanistEmblem = make(prefix(LibItemNames.COSMETIC_PREFIX + "botanist_emblem"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.BOTANIST_EMBLEM, unstackable()));
	public static final class_1792 ancientMask = make(prefix(LibItemNames.COSMETIC_PREFIX + "ancient_mask"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.ANCIENT_MASK, unstackable()));
	public static final class_1792 eerieMask = make(prefix(LibItemNames.COSMETIC_PREFIX + "eerie_mask"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.EERIE_MASK, unstackable()));
	public static final class_1792 alienAntenna = make(prefix(LibItemNames.COSMETIC_PREFIX + "alien_antenna"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.ALIEN_ANTENNA, unstackable()));
	public static final class_1792 anaglyphGlasses = make(prefix(LibItemNames.COSMETIC_PREFIX + "anaglyph_glasses"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.ANAGLYPH_GLASSES, unstackable()));
	public static final class_1792 orangeShades = make(prefix(LibItemNames.COSMETIC_PREFIX + "orange_shades"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.ORANGE_SHADES, unstackable()));
	public static final class_1792 grouchoGlasses = make(prefix(LibItemNames.COSMETIC_PREFIX + "groucho_glasses"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.GROUCHO_GLASSES, unstackable()));
	public static final class_1792 thickEyebrows = make(prefix(LibItemNames.COSMETIC_PREFIX + "thick_eyebrows"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.THICK_EYEBROWS, unstackable()));
	public static final class_1792 lusitanicShield = make(prefix(LibItemNames.COSMETIC_PREFIX + "lusitanic_shield"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.LUSITANIC_SHIELD, unstackable()));
	public static final class_1792 tinyPotatoMask = make(prefix(LibItemNames.COSMETIC_PREFIX + "tiny_potato_mask"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.TINY_POTATO_MASK, unstackable()));
	public static final class_1792 questgiverMark = make(prefix(LibItemNames.COSMETIC_PREFIX + "questgiver_mark"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.QUESTGIVER_MARK, unstackable()));
	public static final class_1792 thinkingHand = make(prefix(LibItemNames.COSMETIC_PREFIX + "thinking_hand"), new CosmeticBaubleItem(CosmeticBaubleItem.Variant.THINKING_HAND, unstackable()));

	public static final class_3917<BaubleBoxContainer> BAUBLE_BOX_CONTAINER = XplatAbstractions.INSTANCE.createMenuType(BaubleBoxContainer::fromNetwork);
	public static final class_3917<FlowerPouchContainer> FLOWER_BAG_CONTAINER = XplatAbstractions.INSTANCE.createMenuType(FlowerPouchContainer::fromNetwork);

	private static <T extends class_1792> T make(class_2960 id, T item) {
		var old = ALL.put(id, item);
		if (old != null) {
			throw new IllegalArgumentException("Typo? Duplicate id " + id);
		}
		return item;
	}

	public static class_1792.class_1793 defaultBuilder() {
		return XplatAbstractions.INSTANCE.defaultItemBuilder();
	}

	// Forge does custom damage by just implementing a method on Item,
	// Fabric does it by an extra lambda to the Properties object
	public static class_1792.class_1793 defaultBuilderCustomDamage() {
		return XplatAbstractions.INSTANCE.defaultItemBuilderWithCustomDamageOnFabric();
	}

	public static class_1792.class_1793 unstackableCustomDamage() {
		return defaultBuilderCustomDamage().method_7889(1);
	}

	private static class_1792.class_1793 stackTo16() {
		return defaultBuilder().method_7889(16);

	}

	private static class_1792.class_1793 unstackable() {
		return defaultBuilder().method_7889(1);
	}

	public static void registerItems(BiConsumer<class_1792, class_2960> r) {
		for (var e : ALL.entrySet()) {
			r.accept(e.getValue(), e.getKey());
		}
	}

	public static void registerMenuTypes(BiConsumer<class_3917<?>, class_2960> consumer) {
		consumer.accept(BAUBLE_BOX_CONTAINER, prefix(LibItemNames.BAUBLE_BOX));
		consumer.accept(FLOWER_BAG_CONTAINER, prefix(LibItemNames.FLOWER_BAG));
	}

	public static void registerRecipeSerializers(BiConsumer<class_1865<?>, class_2960> r) {
		r.accept(AncientWillRecipe.SERIALIZER, prefix("ancient_will_attach"));
		r.accept(ArmorUpgradeRecipe.SERIALIZER, prefix("armor_upgrade"));
		r.accept(BlackHoleTalismanExtractRecipe.SERIALIZER, prefix("black_hole_talisman_extract"));
		r.accept(CompositeLensRecipe.SERIALIZER, prefix("composite_lens"));
		r.accept(CosmeticAttachRecipe.SERIALIZER, prefix("cosmetic_attach"));
		r.accept(CosmeticRemoveRecipe.SERIALIZER, prefix("cosmetic_remove"));
		r.accept(GogAlternationRecipe.SERIALIZER, prefix("gog_alternation"));
		r.accept(ResoluteIvyRecipe.SERIALIZER, prefix("keep_ivy"));
		r.accept(LaputaShardUpgradeRecipe.SERIALIZER, prefix("laputa_shard_upgrade"));
		r.accept(LensDyeingRecipe.SERIALIZER, prefix("lens_dye"));
		r.accept(ManaBlasterClipRecipe.SERIALIZER, prefix("mana_gun_add_clip"));
		r.accept(ManaBlasterLensRecipe.SERIALIZER, prefix("mana_gun_add_lens"));
		r.accept(ManaBlasterRemoveLensRecipe.SERIALIZER, prefix("mana_gun_remove_lens"));
		r.accept(ManaUpgradeRecipe.SERIALIZER, prefix("mana_upgrade"));
		r.accept(ShapelessManaUpgradeRecipe.SERIALIZER, prefix("mana_upgrade_shapeless"));
		r.accept(MergeVialRecipe.SERIALIZER, prefix("merge_vial"));
		r.accept(NbtOutputRecipe.SERIALIZER, prefix("nbt_output_wrapper"));
		r.accept(PhantomInkRecipe.SERIALIZER, prefix("phantom_ink_apply"));
		r.accept(SpellbindingClothRecipe.SERIALIZER, prefix("spell_cloth_apply"));
		r.accept(SplitLensRecipe.SERIALIZER, prefix("split_lens"));
		r.accept(TerraShattererTippingRecipe.SERIALIZER, prefix("terra_pick_tipping"));
		r.accept(WandOfTheForestRecipe.SERIALIZER, prefix("twig_wand"));
		r.accept(WaterBottleMatchingRecipe.SERIALIZER, prefix("water_bottle_matching_shaped"));
	}

	public static class_1792 getPetal(class_1767 color) {
		return switch (color) {
			case field_7952 -> whitePetal;
			case field_7946 -> orangePetal;
			case field_7958 -> magentaPetal;
			case field_7951 -> lightBluePetal;
			case field_7947 -> yellowPetal;
			case field_7961 -> limePetal;
			case field_7954 -> pinkPetal;
			case field_7944 -> grayPetal;
			case field_7967 -> lightGrayPetal;
			case field_7955 -> cyanPetal;
			case field_7945 -> purplePetal;
			case field_7966 -> bluePetal;
			case field_7957 -> brownPetal;
			case field_7942 -> greenPetal;
			case field_7964 -> redPetal;
			case field_7963 -> blackPetal;
		};
	}

	public static boolean isNoDespawn(class_1792 item) {
		return item instanceof ManaTabletItem || item instanceof BandOfManaItem || item instanceof TerraShattererItem
				|| item instanceof RelicItem || item instanceof RelicBaubleItem;
	}

}
