/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.internal_caps;

import net.minecraft.class_2487;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;

// Component for misc internal Botania flags
public class ItemFlagsComponent extends SerializableComponent {
	public boolean alfPortalSpawned = false;
	public boolean apothecarySpawned = false;
	/**
	 * Similar to the age field on the actual entity, but always increases by 1 every tick,
	 * no magic values like vanilla -32768, etc.
	 * Initialized to zero by default, but may still be initialized to values less
	 * than zero in certain scenarios.
	 */
	public int timeCounter = 0;
	/**
	 * Set to {@link #INITIAL_MANA_INFUSION_COOLDOWN} when an item is output by the pool then cools off to 0.
	 * Used so certain mechanics don't interact with items immediately after they're produced.
	 */
	private int manaInfusionCooldown = 0;
	public static final int INITIAL_MANA_INFUSION_COOLDOWN = 25;

	@Override
	public void readFromNbt(class_2487 tag) {
		alfPortalSpawned = tag.method_10577(AlfheimPortalBlockEntity.TAG_PORTAL_FLAG);
		apothecarySpawned = tag.method_10577(PetalApothecaryBlockEntity.ITEM_TAG_APOTHECARY_SPAWNED);
		timeCounter = tag.method_10550("timeCounter");
		manaInfusionCooldown = tag.method_10550("manaInfusionCooldown");
	}

	@Override
	public void writeToNbt(class_2487 tag) {
		tag.method_10556(AlfheimPortalBlockEntity.TAG_PORTAL_FLAG, alfPortalSpawned);
		tag.method_10556(PetalApothecaryBlockEntity.ITEM_TAG_APOTHECARY_SPAWNED, apothecarySpawned);
		tag.method_10569("timeCounter", timeCounter);
		tag.method_10569("manaInfusionCooldown", manaInfusionCooldown);
	}

	public void tick() {
		timeCounter++;
		if (manaInfusionCooldown > 0) {
			manaInfusionCooldown--;
		}
	}

	public int getManaInfusionCooldown() {
		return manaInfusionCooldown;
	}

	public void markNewlyInfused() {
		manaInfusionCooldown = INITIAL_MANA_INFUSION_COOLDOWN;
	}
}
