/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.collect.ImmutableList;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaSpark;

import java.util.List;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class SidedVanillaCorporeaNode extends AbstractCorporeaNode {
	private final class_1278 inv;
	private final class_2350 side;

	public SidedVanillaCorporeaNode(class_1937 world, class_2338 pos, CorporeaSpark spark, class_1278 inv, class_2350 side) {
		super(world, pos, spark);
		this.inv = inv;
		this.side = side;
	}

	@Override
	public List<class_1799> countItems(CorporeaRequest request) {
		return examineInventory(request, false);
	}

	@Override
	public List<class_1799> extractItems(CorporeaRequest request) {
		return examineInventory(request, true);
	}

	protected List<class_1799> examineInventory(CorporeaRequest request, boolean doit) {
		ImmutableList.Builder<class_1799> builder = ImmutableList.builder();

		int[] slots = inv.method_5494(side);
		for (int i = slots.length - 1; i >= 0; i--) {
			int slot = slots[i];
			class_1799 stack = inv.method_5438(slot);
			boolean canTake = inv.method_5493(slot, stack, side);

			if (canTake && request.getMatcher().test(stack)) {
				request.trackFound(stack.method_7947());

				int rem = Math.min(stack.method_7947(), request.getStillNeeded() == -1 ? stack.method_7947() : request.getStillNeeded());
				if (rem > 0) {
					request.trackSatisfied(rem);

					class_1799 copy = stack.method_7972();
					copy.method_7939(rem);
					if (doit) {
						if (getSpark().isCreative()) {
							builder.add(copy);
						} else {
							builder.addAll(breakDownBigStack(inv.method_5434(i, rem)));
						}
						getSpark().onItemExtracted(copy);
						request.trackExtracted(rem);
					} else {
						copy.method_7939(rem);
						builder.add(copy);
					}
				}
			}
		}

		return builder.build();
	}
}
