/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.impl.corporea;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.common.helper.ItemNBTHelper;

public class CorporeaItemStackMatcher implements CorporeaRequestMatcher {
	private static final String TAG_REQUEST_STACK = "requestStack";
	private static final String TAG_REQUEST_CHECK_NBT = "requestCheckNBT";

	private final class_1799 match;
	private final boolean checkNBT;

	public CorporeaItemStackMatcher(class_1799 match, boolean checkNBT) {
		this.match = match;
		this.checkNBT = checkNBT;
	}

	@Override
	public boolean test(class_1799 stack) {
		return !stack.method_7960() && !match.method_7960() && stack.method_7962(match) && (!checkNBT || ItemNBTHelper.matchTagAndManaFullness(stack, match));
	}

	public static CorporeaItemStackMatcher createFromNBT(class_2487 tag) {
		return new CorporeaItemStackMatcher(class_1799.method_7915(tag.method_10562(TAG_REQUEST_STACK)), tag.method_10577(TAG_REQUEST_CHECK_NBT));
	}

	@Override
	public void writeToNBT(class_2487 tag) {
		class_2487 cmp = match.method_7953(new class_2487());
		tag.method_10566(TAG_REQUEST_STACK, cmp);
		tag.method_10556(TAG_REQUEST_CHECK_NBT, checkNBT);
	}

	@Override
	public class_2561 getRequestName() {
		return match.method_7954();
	}
}
