package vazkii.botania.common.helper;

import net.minecraft.class_1542;
import net.minecraft.class_1799;

public class EntityHelper {
	/**
	 * Shrinks the itemstack in an entity and ensures that the new size is sent to clients
	 */
	public static void shrinkItem(class_1542 entity) {
		entity.method_6983().method_7934(1);
		syncItem(entity);
	}

	/**
	 * Forces an item entity to resync its item to the client.
	 *
	 * Entity data only resyncs when the old/new values are not Object.equals().
	 * Since stacks do not implement equals, and we're not changing the actual stack object,
	 * the old/new values are == and thus the game doesn't resync.
	 * We have to set a dummy value then set it back to tell the game to resync.
	 */
	public static void syncItem(class_1542 entity) {
		var save = entity.method_6983();
		entity.method_6979(class_1799.field_8037);
		entity.method_6979(save);
	}
}
