/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableList.Builder;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;
import net.minecraft.class_1863;
import net.minecraft.class_2680;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3956;
import net.minecraft.class_4013;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class OrechidManager implements class_4013 {
	private static final Map<class_3956<? extends OrechidRecipe>, Map<class_2680, List<? extends OrechidRecipe>>> BY_TYPE = new IdentityHashMap<>();

	public static void registerListener() {
		XplatAbstractions.INSTANCE.registerReloadListener(class_3264.field_14190, prefix("orechid"), new OrechidManager());
	}

	@Override
	public void method_14491(@NotNull class_3300 manager) {
		BY_TYPE.clear();
	}

	public static <T extends OrechidRecipe> Collection<T> getMatchingRecipes(
			class_1863 manager,
			class_3956<T> type,
			class_2680 state) {
		var byState = BY_TYPE.get(type);
		if (byState == null) {
			byState = new IdentityHashMap<>();
			BY_TYPE.put(type, byState);
		}

		var list = byState.get(state);
		if (list == null) {
			var builder = ImmutableList.<T>builder();
			for (var recipe : manager.method_30027(type)) {
				if (recipe.getInput().test(state)) {
					builder.add(recipe);
				}
			}
			list = builder.build();
			byState.put(state, list);
		}

		@SuppressWarnings("unchecked") // we only add T's to this list in the above loop
		List<T> result = (List<T>) list;
		return result;
	}
}
