/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.handler;

import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public abstract class EquipmentHandler {
	public static EquipmentHandler instance;

	public static void init() {
		if (instance == null) {
			instance = XplatAbstractions.INSTANCE.tryCreateEquipmentHandler();
		}

		// Fall back to hotbar
		if (instance == null) {
			instance = new InventoryEquipmentHandler();
		}
	}

	public static class_1263 getAllWorn(class_1309 living) {
		return instance.getAllWornItems(living);
	}

	public static class_1799 findOrEmpty(class_1792 item, class_1309 living) {
		return instance.findItem(item, living);
	}

	public static class_1799 findOrEmpty(Predicate<class_1799> pred, class_1309 living) {
		return instance.findItem(pred, living);
	}

	protected abstract class_1263 getAllWornItems(class_1309 living);

	protected abstract class_1799 findItem(class_1792 item, class_1309 living);

	protected abstract class_1799 findItem(Predicate<class_1799> pred, class_1309 living);

	public abstract void onInit(class_1792 item);

	public boolean isAccessory(class_1799 stack) {
		return stack.method_31573(BotaniaTags.Items.RODS) || stack.method_7909() instanceof BaubleItem || XplatAbstractions.INSTANCE.findManaItem(stack) != null;
	}

	// Fallback equipment handler for curios-less (or baubles-less) installs.
	public static class InventoryEquipmentHandler extends EquipmentHandler {
		private final Map<class_1657, class_1799[]> map = new WeakHashMap<>();

		public void onPlayerTick(class_1657 player) {
			player.field_6002.method_16107().method_15396("botania:tick_wearables");

			class_1799[] oldStacks = map.computeIfAbsent(player, p -> {
				class_1799[] array = new class_1799[9];
				Arrays.fill(array, class_1799.field_8037);
				return array;
			});

			class_1661 inv = player.method_31548();
			for (int i = 0; i < 9; i++) {
				class_1799 old = oldStacks[i];
				class_1799 current = inv.method_5438(i);

				if (!class_1799.method_7973(old, current)) {
					if (old.method_7909() instanceof BaubleItem bauble) {
						player.method_6127().method_26847(bauble.getEquippedAttributeModifiers(old));
						bauble.onUnequipped(old, player);
					}
					if (canEquip(current, player)) {
						BaubleItem bauble = (BaubleItem) current.method_7909();
						player.method_6127().method_26854(bauble.getEquippedAttributeModifiers(current));
						bauble.onEquipped(current, player);
					}
					oldStacks[i] = current.method_7972(); // shift-clicking mutates the stack we stored,
					// making it empty and failing the equality check - let's avoid that
				}

				if (canEquip(current, player)) {
					((BaubleItem) current.method_7909()).onWornTick(current, player);
				}
			}
			player.field_6002.method_16107().method_15407();
		}

		@Override
		protected class_1263 getAllWornItems(class_1309 living) {
			return new class_1277(0);
		}

		@Override
		protected class_1799 findItem(class_1792 item, class_1309 living) {
			if (living instanceof class_1657 player) {
				class_1661 inv = player.method_31548();
				for (int i = 0; i < 9; i++) {
					class_1799 stack = inv.method_5438(i);
					if (stack.method_31574(item) && canEquip(stack, living)) {
						return stack;
					}
				}
			}
			return class_1799.field_8037;
		}

		@Override
		protected class_1799 findItem(Predicate<class_1799> pred, class_1309 living) {
			if (living instanceof class_1657 player) {
				class_1661 inv = player.method_31548();
				for (int i = 0; i < 9; i++) {
					class_1799 stack = inv.method_5438(i);
					if (pred.test(stack) && canEquip(stack, living)) {
						return stack;
					}
				}
			}
			return class_1799.field_8037;
		}

		@Override
		public void onInit(class_1792 item) {}

		private static boolean canEquip(class_1799 stack, class_1309 living) {
			return stack.method_7909() instanceof BaubleItem bauble && bauble.canEquip(stack, living);
		}
	}
}
