/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class BotaniaSounds {
	private static final List<class_3414> EVENTS = new ArrayList<>();
	//blocks
	public static final class_3414 altarCraft = makeSoundEvent("altar_craft");
	public static final class_3414 bellows = makeSoundEvent("bellows");
	public static final class_3414 drum = makeSoundEvent("drum");
	public static final class_3414 enchanterEnchant = makeSoundEvent("enchanter_enchant");
	public static final class_3414 enchanterFade = makeSoundEvent("enchanter_fade");
	public static final class_3414 enchanterForm = makeSoundEvent("enchanter_form");
	public static final class_3414 hornDoot = makeSoundEvent("horn_doot");
	public static final class_3414 incensePlateIgnite = makeSoundEvent("incense_plate_ignite");
	public static final class_3414 lightRelay = makeSoundEvent("light_relay");
	public static final class_3414 manaPoolCraft = makeSoundEvent("mana_pool_craft");
	public static final class_3414 potionCreate = makeSoundEvent("potion_create");
	public static final class_3414 redStringInterceptorClick = makeSoundEvent("red_string_interceptor_click");
	public static final class_3414 runeAltarCraft = makeSoundEvent("rune_altar_craft");
	public static final class_3414 runeAltarStart = makeSoundEvent("rune_altar_start");
	public static final class_3414 prismAddLens = makeSoundEvent("prism_add_lens");
	public static final class_3414 prismRemoveLens = makeSoundEvent("prism_remove_lens");
	public static final class_3414 spreaderAddLens = makeSoundEvent("spreader_add_lens");
	public static final class_3414 spreaderRemoveLens = makeSoundEvent("spreader_remove_lens");
	public static final class_3414 spreaderCover = makeSoundEvent("spreader_cover");
	public static final class_3414 spreaderUncover = makeSoundEvent("spreader_uncover");
	public static final class_3414 spreaderScaffold = makeSoundEvent("spreader_scaffold");
	public static final class_3414 spreaderUnScaffold = makeSoundEvent("spreader_un_scaffold");
	public static final class_3414 spreaderFire = makeSoundEvent("spreader_fire");
	public static final class_3414 terrasteelCraft = makeSoundEvent("terrasteel_craft");

	//items, rods, and trinkets
	public static final class_3414 airRod = makeSoundEvent("air_rod");
	public static final class_3414 astrolabeConfigure = makeSoundEvent("astrolabe_configure");
	public static final class_3414 bifrostRod = makeSoundEvent("bifrost_rod");
	public static final class_3414 blackHoleTalismanConfigure = makeSoundEvent("black_hole_talisman_configure");
	public static final class_3414 blackLotus = makeSoundEvent("black_lotus");
	public static final class_3414 dash = makeSoundEvent("dash");
	public static final class_3414 diceOfFate = makeSoundEvent("dice_of_fate");
	public static final class_3414 divaCharm = makeSoundEvent("diva_charm");
	public static final class_3414 divinationRod = makeSoundEvent("divination_rod");
	public static final class_3414 enderAirThrow = makeSoundEvent("ender_air_throw");
	public static final class_3414 equipBauble = makeSoundEvent("equip_bauble");
	public static final class_3414 equipElementium = makeSoundEvent("equip_elementium");
	public static final class_3414 equipManasteel = makeSoundEvent("equip_manasteel");
	public static final class_3414 equipManaweave = makeSoundEvent("equip_manaweave");
	public static final class_3414 equipTerrasteel = makeSoundEvent("equip_terrasteel");
	public static final class_3414 fireRod = makeSoundEvent("fire_rod");
	public static final class_3414 flareChakramThrow = makeSoundEvent("flare_chakram_throw");
	public static final class_3414 flugelEyeBind = makeSoundEvent("flugel_eye_bind");
	public static final class_3414 flugelEyeTeleport = makeSoundEvent("flugel_eye_teleport");
	public static final class_3414 holyCloak = makeSoundEvent("holy_cloak");
	public static final class_3414 laputaStart = makeSoundEvent("laputa_start");
	public static final class_3414 lexiconOpen = makeSoundEvent("lexicon_open");
	//public static final SoundEvent lexiconPage = makeSoundEvent("lexicon_page");
	public static final class_3414 manaBlaster = makeSoundEvent("mana_blaster");
	public static final class_3414 manaBlasterCycle = makeSoundEvent("mana_blaster_cycle");
	public static final class_3414 manaBlasterMisfire = makeSoundEvent("mana_blaster_misfire");
	public static final class_3414 missile = makeSoundEvent("missile");
	public static final class_3414 missileFunny = makeSoundEvent("missile_funny"); //pew pew
	public static final class_3414 pinkinator = makeSoundEvent("pinkinator");
	public static final class_3414 smeltRod = makeSoundEvent("smelt_rod");
	public static final class_3414 smeltRod2 = makeSoundEvent("smelt_rod_extra_no_subtitle");
	public static final class_3414 smeltRodSimmer = makeSoundEvent("smelt_rod_simmer");
	public static final class_3414 starcaller = makeSoundEvent("starcaller");
	public static final class_3414 temperanceStoneConfigure = makeSoundEvent("temperance_stone_configure");
	public static final class_3414 terraBlade = makeSoundEvent("terrablade");
	public static final class_3414 terraPickMode = makeSoundEvent("terra_pick_mode");
	public static final class_3414 terraformRod = makeSoundEvent("terraform_rod");
	public static final class_3414 thornChakramThrow = makeSoundEvent("thorn_chakram_throw");
	public static final class_3414 unholyCloak = makeSoundEvent("unholy_cloak");
	public static final class_3414 vineBallThrow = makeSoundEvent("vine_ball_throw");
	public static final class_3414 virusInfect = makeSoundEvent("virus_infect");
	public static final class_3414 worldSeedTeleport = makeSoundEvent("world_seed_teleport");

	//flowers
	public static final class_3414 agricarnation = makeSoundEvent("agricarnation");
	public static final class_3414 arcaneRoseDisenchant = makeSoundEvent("arcane_rose_disenchant");
	public static final class_3414 endoflame = makeSoundEvent("endoflame");
	public static final class_3414 entropinnyumAngry = makeSoundEvent("entropinnyum_angry");
	public static final class_3414 entropinnyumHappy = makeSoundEvent("entropinnyum_happy");
	public static final class_3414 labellia = makeSoundEvent("labellia");
	public static final class_3414 narslimmusEatBig = makeSoundEvent("narslimmus_eat_big");
	public static final class_3414 narslimmusEatSmall = makeSoundEvent("narslimmus_eat_small");
	public static final class_3414 orechid = makeSoundEvent("orechid");
	public static final class_3414 shulkMeNot = makeSoundEvent("shulk_me_not");
	public static final class_3414 thermalily = makeSoundEvent("thermalily");
	public static final class_3414 tigerseyePacify = makeSoundEvent("tigerseye_pacify");

	//entities
	public static final class_3414 babylonAttack = makeSoundEvent("babylon_attack");
	public static final class_3414 babylonSpawn = makeSoundEvent("babylon_spawn");
	public static final class_3414 gaiaDeath = makeSoundEvent("gaia_death");
	public static final class_3414 gaiaSummon = makeSoundEvent("gaia_summon");
	public static final class_3414 gaiaTeleport = makeSoundEvent("gaia_teleport");
	public static final class_3414 gaiaTrap = makeSoundEvent("gaia_trap");

	//misc
	public static final class_3414 ding = makeSoundEvent("ding");
	public static final class_3414 doit = makeSoundEvent("doit");

	//music
	public static final class_3414 gaiaMusic1 = makeSoundEvent("music.gaia1");
	public static final class_3414 gaiaMusic2 = makeSoundEvent("music.gaia2");
	public static final class_3414 way = makeSoundEvent("way");

	private static class_3414 makeSoundEvent(String name) {
		class_3414 event = new class_3414(prefix(name));
		EVENTS.add(event);
		return event;
	}

	public static void init(BiConsumer<class_3414, class_2960> r) {
		for (class_3414 event : EVENTS) {
			r.accept(event, event.method_14833());
		}
	}

	private BotaniaSounds() {}
}
