/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.mixin.ItemEntityAccessor;

import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2643;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class ThrownItemEntity extends class_1542 {
	public ThrownItemEntity(class_1299<ThrownItemEntity> type, class_1937 world) {
		super(type, world);
	}

	public ThrownItemEntity(class_1937 world, double x,
			double y, double z, class_1542 item) {
		super(world, x, y, z, item.method_6983());
		method_6982(((ItemEntityAccessor) item).getPickupDelay());
		method_18799(item.method_18798());
		method_5684(true);
	}

	@NotNull
	@Override
	public class_1299<?> method_5864() {
		return BotaniaEntities.THROWN_ITEM;
	}

	@Override
	public void method_5773() {
		super.method_5773();

		// [VanillaCopy] derivative from ThrowableProjectile
		int pickupDelay = ((ItemEntityAccessor) this).getPickupDelay();
		Predicate<class_1297> filter = e -> !e.method_7325() && e.method_5805() && e.method_5863() && (!(e instanceof class_1657) || pickupDelay == 0);
		class_239 hitResult = class_1675.method_18074(this, filter);
		boolean teleported = false;
		if (hitResult.method_17783() == class_239.class_240.field_1332) {
			class_2338 blockPos = ((class_3965) hitResult).method_17777();
			class_2680 blockState = this.field_6002.method_8320(blockPos);
			if (blockState.method_27852(class_2246.field_10316)) {
				this.method_5717(blockPos);
				teleported = true;
			} else if (blockState.method_27852(class_2246.field_10613)) {
				class_2586 blockEntity = this.field_6002.method_8321(blockPos);
				if (blockEntity instanceof class_2643 gateway && class_2643.method_30276(this)) {
					class_2643.method_11409(this.field_6002, blockPos, blockState, this, gateway);
				}

				teleported = true;
			}
		}

		if (teleported) {
			return;
		}

		// Bonk any entities hit
		if (!field_6002.field_9236 && hitResult.method_17783() == class_239.class_240.field_1331) {
			class_1297 bonk = ((class_3966) hitResult).method_17782();
			bonk.method_5643(class_1282.field_5846, 2.0F);
			class_1297 item = new class_1542(field_6002, method_23317(), method_23318(), method_23321(), method_6983());
			field_6002.method_8649(item);
			item.method_18799(method_18798().method_1021(0.25));
			method_31472();
			return;
		}

		if (!field_6002.field_9236 && method_18798().method_1033() < 1.0F) {
			class_1297 item = new class_1542(field_6002, method_23317(), method_23318(), method_23321(), method_6983());
			field_6002.method_8649(item);
			item.method_18799(method_18798());
			method_31472();
		}
	}
}
