/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2261;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;

public class ThornChakramEntity extends class_1682 implements class_3856 {
	private static final class_2940<Integer> BOUNCES = class_2945.method_12791(ThornChakramEntity.class, class_2943.field_13327);
	private static final class_2940<Boolean> FLARE = class_2945.method_12791(ThornChakramEntity.class, class_2943.field_13323);
	private static final class_2940<Integer> RETURN_TO = class_2945.method_12791(ThornChakramEntity.class, class_2943.field_13327);
	private static final int MAX_BOUNCES = 16;
	private boolean bounced = false;
	private class_1799 stack = class_1799.field_8037;

	public ThornChakramEntity(class_1299<ThornChakramEntity> type, class_1937 world) {
		super(type, world);
	}

	public ThornChakramEntity(class_1309 e, class_1937 world, class_1799 stack) {
		super(BotaniaEntities.THORN_CHAKRAM, e, world);
		this.stack = stack.method_7972();
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(BOUNCES, 0);
		field_6011.method_12784(FLARE, false);
		field_6011.method_12784(RETURN_TO, -1);
	}

	@Override
	public boolean method_5659() {
		return true;
	}

	@Override
	public void method_5773() {
		// Standard motion
		class_243 old = method_18798();

		super.method_5773();

		if (!bounced) {
			// Reset the drag applied by super
			method_18799(old);
		}

		bounced = false;

		// Returning motion
		if (isReturning()) {
			class_1297 thrower = method_24921();
			if (thrower != null) {
				class_243 motion = VecHelper.fromEntityCenter(thrower).method_1020(VecHelper.fromEntityCenter(this)).method_1029();
				method_18799(motion);
			}
		}

		// Client FX
		if (field_6002.field_9236 && isFire()) {
			double r = 0.1;
			double m = 0.1;
			for (int i = 0; i < 3; i++) {
				field_6002.method_8406(class_2398.field_11240, method_23317() + r * (Math.random() - 0.5), method_23318() + r * (Math.random() - 0.5), method_23321() + r * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5));
			}
		}

		// Server state control
		if (!field_6002.field_9236 && (getTimesBounced() >= MAX_BOUNCES || field_6012 > 60)) {
			class_1297 thrower = method_24921();
			if (thrower == null) {
				dropAndKill();
			} else {
				setEntityToReturnTo(thrower.method_5628());
				if (method_5858(thrower) < 2) {
					dropAndKill();
				}
			}
		}
	}

	private void dropAndKill() {
		class_1799 stack = getItemStack();
		class_1542 item = new class_1542(field_6002, method_23317(), method_23318(), method_23321(), stack);
		field_6002.method_8649(item);
		method_31472();
	}

	private class_1799 getItemStack() {
		return !stack.method_7960()
				? stack.method_7972()
				: isFire() ? new class_1799(BotaniaItems.flareChakram) : new class_1799(BotaniaItems.thornChakram);
	}

	@Override
	protected void method_7488(@NotNull class_239 pos) {
		if (!isReturning()) {
			super.method_7488(pos);
		}
	}

	@Override
	protected void method_24920(@NotNull class_3965 hit) {
		super.method_24920(hit);
		class_2680 state = field_6002.method_8320(hit.method_17777());
		if (state.method_26204() instanceof class_2261 || state.method_26164(class_3481.field_15503)) {
			return;
		}

		int bounces = getTimesBounced();
		if (bounces < MAX_BOUNCES) {
			class_243 currentMovementVec = method_18798();
			class_2350 dir = hit.method_17780();
			class_243 normalVector = new class_243(dir.method_10148(), dir.method_10164(), dir.method_10165()).method_1029();
			class_243 movementVec = normalVector.method_1021(-2 * currentMovementVec.method_1026(normalVector)).method_1019(currentMovementVec);

			method_18799(movementVec);
			bounced = true;

			if (!field_6002.field_9236) {
				setTimesBounced(getTimesBounced() + 1);
			}
		}
	}

	@Override
	protected void method_7454(@NotNull class_3966 hit) {
		super.method_7454(hit);
		if (!field_6002.field_9236 && hit.method_17782() instanceof class_1309 hitEntity && hit.method_17782() != method_24921()) {
			class_1297 thrower = method_24921();
			class_1282 src = class_1282.field_5869;
			if (thrower instanceof class_1657) {
				src = class_1282.method_5524(this, thrower);
			} else if (thrower instanceof class_1309 livingEntity) {
				src = class_1282.method_5511(livingEntity);
			}
			hitEntity.method_5643(src, 12);
			if (isFire()) {
				hitEntity.method_5639(5);
			} else if (field_6002.field_9229.method_43048(3) == 0) {
				hitEntity.method_6092(new class_1293(class_1294.field_5899, 60, 0));
			}
		}
	}

	@Override
	protected float method_7490() {
		return 0F;
	}

	private int getTimesBounced() {
		return field_6011.method_12789(BOUNCES);
	}

	private void setTimesBounced(int times) {
		field_6011.method_12778(BOUNCES, times);
	}

	public boolean isFire() {
		return field_6011.method_12789(FLARE);
	}

	public void setFire(boolean fire) {
		field_6011.method_12778(FLARE, fire);
	}

	private boolean isReturning() {
		return getEntityToReturnTo() > -1;
	}

	private int getEntityToReturnTo() {
		return field_6011.method_12789(RETURN_TO);
	}

	private void setEntityToReturnTo(int entityID) {
		field_6011.method_12778(RETURN_TO, entityID);
	}

	@Override
	public void method_5652(class_2487 compound) {
		super.method_5652(compound);
		if (!stack.method_7960()) {
			compound.method_10566("fly_stack", stack.method_7953(new class_2487()));
		}
		compound.method_10556("flare", isFire());
	}

	@Override
	public void method_5749(class_2487 compound) {
		super.method_5749(compound);
		if (compound.method_10545("fly_stack")) {
			stack = class_1799.method_7915(compound.method_10562("fly_stack"));
		}
		setFire(compound.method_10577("flare"));
	}

	@NotNull
	@Override
	public class_1799 method_7495() {
		return getItemStack();
	}
}
