/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.item.SparkEntity;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

public abstract class SparkBaseEntity extends class_1297 implements SparkEntity {
	private static final String TAG_INVIS = "invis";
	private static final String TAG_NETWORK = "network";
	private static final class_2940<Integer> NETWORK = class_2945.method_12791(SparkBaseEntity.class, class_2943.field_13327);

	public SparkBaseEntity(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(NETWORK, 0);
	}

	@Override
	public class_2338 getAttachPos() {
		int x = class_3532.method_15357(method_23317());
		int y = class_3532.method_15357(method_23318() - 1);
		int z = class_3532.method_15357(method_23321());
		return new class_2338(x, y, z);
	}

	@Nullable
	@Override
	public ManaReceiver getAttachedManaReceiver() {
		return XplatAbstractions.INSTANCE.findManaReceiver(field_6002, getAttachPos(), class_2350.field_11036);
	}

	@Override
	public class_1767 getNetwork() {
		return class_1767.method_7791(field_6011.method_12789(NETWORK));
	}

	@Override
	public void setNetwork(class_1767 color) {
		field_6011.method_12778(NETWORK, color.method_7789());
	}

	@Override
	public boolean method_5863() {
		return true;
	}

	@Override
	protected void method_5749(class_2487 compound) {
		method_5648(compound.method_10577(TAG_INVIS));
		setNetwork(class_1767.method_7791(compound.method_10550(TAG_NETWORK)));
	}

	@Override
	protected void method_5652(class_2487 compound) {
		compound.method_10556(TAG_INVIS, method_5767());
		compound.method_10569(TAG_NETWORK, getNetwork().method_7789());
	}

	@Override
	public class_2596<?> method_18002() {
		return new class_2604(this);
	}
}
