/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.item.BotaniaItems;

public class ManaStormEntity extends class_1297 {
	private static final String TAG_TIME = "time";
	private static final String TAG_BURST_COLOR = "burstColor";
	private static final String TAG_BURSTS_FIRED = "burstsFired";
	private static final String TAG_DEATH_TIME = "deathTime";

	public static final int TOTAL_BURSTS = 250;
	public static final int DEATH_TIME = 200;

	public int liveTime;
	public int burstColor;
	public int burstsFired;
	public int deathTime;

	public ManaStormEntity(class_1299<ManaStormEntity> type, class_1937 world) {
		super(type, world);
	}

	@Override
	protected void method_5693() {}

	@Override
	public void method_5773() {
		super.method_5773();
		liveTime++;

		int diffTime = Math.max(1, 30 - (int) (liveTime / 45f));
		if (burstsFired < TOTAL_BURSTS && liveTime % diffTime == 0) {
			if (!field_6002.field_9236) {
				spawnBurst();
			}
			burstsFired++;
		}

		if (burstsFired >= TOTAL_BURSTS) {
			deathTime++;
			if (deathTime >= DEATH_TIME) {
				method_31472();
				field_6002.method_8537(this, method_23317(), method_23318(), method_23321(), 8F, true, class_1927.class_4179.field_18687);
			}
		}
	}

	private void spawnBurst() {
		ManaBurstEntity burst = BotaniaEntities.MANA_BURST.method_5883(field_6002);
		burst.method_5814(method_23317(), method_23318(), method_23321());

		float motionModifier = 0.5F;
		burst.setColor(burstColor);
		burst.setMana(120);
		burst.setStartingMana(340);
		burst.setMinManaLoss(50);
		burst.setManaLossPerTick(1F);
		burst.setGravity(0F);

		burst.setSourceLens(new class_1799(BotaniaItems.lensStorm));

		class_243 motion = new class_243(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).method_1029().method_1021(motionModifier);
		burst.method_18799(motion);
		field_6002.method_8649(burst);
	}

	@Override
	protected void method_5749(@NotNull class_2487 cmp) {
		liveTime = cmp.method_10550(TAG_TIME);
		burstColor = cmp.method_10550(TAG_BURST_COLOR);
		burstsFired = cmp.method_10550(TAG_BURSTS_FIRED);
		deathTime = cmp.method_10550(TAG_DEATH_TIME);
	}

	@Override
	protected void method_5652(@NotNull class_2487 cmp) {
		cmp.method_10569(TAG_TIME, liveTime);
		cmp.method_10569(TAG_BURST_COLOR, burstColor);
		cmp.method_10569(TAG_BURSTS_FIRED, burstsFired);
		cmp.method_10569(TAG_DEATH_TIME, deathTime);
	}

	@NotNull
	@Override
	public class_2596<?> method_18002() {
		return new class_2604(this);
	}

}
