/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.SparkAugmentItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;
import java.util.Map.Entry;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public class ManaSparkEntity extends SparkBaseEntity implements ManaSpark {
	private static final int TRANSFER_RATE = 1000;
	private static final String TAG_UPGRADE = "upgrade";
	private static final class_2940<Integer> UPGRADE = class_2945.method_12791(ManaSparkEntity.class, class_2943.field_13327);

	private final Set<ManaSpark> transfers = Collections.newSetFromMap(new WeakHashMap<>());

	private int removeTransferants = 2;

	public ManaSparkEntity(class_1299<ManaSparkEntity> type, class_1937 world) {
		super(type, world);
	}

	public ManaSparkEntity(class_1937 world) {
		this(BotaniaEntities.SPARK, world);
	}

	@Override
	protected void method_5693() {
		super.method_5693();
		field_6011.method_12784(UPGRADE, 0);
	}

	@NotNull
	@Override
	public class_1799 method_31480() {
		return new class_1799(BotaniaItems.spark);
	}

	@Override
	public void method_5773() {
		super.method_5773();

		if (field_6002.field_9236) {
			return;
		}

		SparkAttachable tile = getAttachedTile();
		if (tile == null) {
			dropAndKill();
			return;
		}
		var receiver = getAttachedManaReceiver();

		SparkUpgradeType upgrade = getUpgrade();
		Collection<ManaSpark> transfers = getTransfers();

		switch (upgrade) {
			case DISPERSIVE -> {
				class_238 aabb = VecHelper.boxForRange(
						this.method_19538().method_38499(class_2350.class_2351.field_11052, method_23318() + (method_17682() / 2.0)),
						SparkHelper.SPARK_SCAN_RANGE);
				List<class_1657> players = field_6002.method_8390(class_1657.class, aabb, class_1301.field_6154);

				Map<class_1657, Map<ManaItem, Integer>> receivingPlayers = new HashMap<>();

				class_1799 input = new class_1799(BotaniaItems.spark);
				for (class_1657 player : players) {
					List<class_1799> stacks = new ArrayList<>();
					stacks.addAll(player.method_31548().field_7547);
					stacks.addAll(player.method_31548().field_7548);

					class_1263 inv = BotaniaAPI.instance().getAccessoriesInventory(player);
					for (int i = 0; i < inv.method_5439(); i++) {
						stacks.add(inv.method_5438(i));
					}

					for (class_1799 stack : stacks) {
						var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
						if (stack.method_7960() || manaItem == null) {
							continue;
						}

						if (manaItem.canReceiveManaFromItem(input)) {
							Map<ManaItem, Integer> receivingStacks;
							boolean add = false;
							if (!receivingPlayers.containsKey(player)) {
								add = true;
								receivingStacks = new HashMap<>();
							} else {
								receivingStacks = receivingPlayers.get(player);
							}

							int recv = Math.min(receiver.getCurrentMana(), Math.min(TRANSFER_RATE, manaItem.getMaxMana() - manaItem.getMana()));
							if (recv > 0) {
								receivingStacks.put(manaItem, recv);
								if (add) {
									receivingPlayers.put(player, receivingStacks);
								}
							}
						}
					}
				}

				if (!receivingPlayers.isEmpty()) {
					List<class_1657> keys = new ArrayList<>(receivingPlayers.keySet());
					Collections.shuffle(keys);
					class_1657 player = keys.iterator().next();

					Map<ManaItem, Integer> items = receivingPlayers.get(player);
					var e = items.entrySet().iterator().next();
					ManaItem manaItem = e.getKey();
					int cost = e.getValue();
					int manaToPut = Math.min(receiver.getCurrentMana(), cost);
					manaItem.addMana(manaToPut);
					receiver.receiveMana(-manaToPut);
					particlesTowards(player);
				}

			}
			case DOMINANT -> {
				List<ManaSpark> validSparks = SparkHelper.getSparksAround(field_6002, method_23317(), method_23318() + (method_17682() / 2), method_23321(), getNetwork());
				validSparks.removeIf(s -> {
					SparkUpgradeType otherUpgrade = s.getUpgrade();
					return s == this || otherUpgrade != SparkUpgradeType.NONE || !(s.getAttachedManaReceiver() instanceof ManaPool);
				});
				if (!validSparks.isEmpty()) {
					validSparks.get(field_6002.field_9229.method_43048(validSparks.size())).registerTransfer(this);
				}

			}
			case RECESSIVE -> {
				var otherSparks = SparkHelper.getSparksAround(field_6002, method_23317(), method_23318() + (method_17682() / 2), method_23321(), getNetwork());
				for (var otherSpark : otherSparks) {
					SparkUpgradeType otherUpgrade = otherSpark.getUpgrade();
					if (otherSpark != this
							&& otherUpgrade != SparkUpgradeType.DOMINANT
							&& otherUpgrade != SparkUpgradeType.RECESSIVE
							&& otherUpgrade != SparkUpgradeType.ISOLATED) {
						transfers.add(otherSpark);
					}
				}
			}
			default -> {}
		}

		if (!transfers.isEmpty()) {
			int manaTotal = Math.min(TRANSFER_RATE * transfers.size(), receiver.getCurrentMana());
			int count = transfers.size();
			int manaSpent = 0;

			if (manaTotal > 0) {
				for (ManaSpark spark : transfers) {
					count--;
					SparkAttachable attached = spark.getAttachedTile();
					var attachedReceiver = spark.getAttachedManaReceiver();
					if (attached == null || attachedReceiver == null || attachedReceiver.isFull() || spark.areIncomingTransfersDone()) {
						continue;
					}

					int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
					attachedReceiver.receiveMana(spend);
					manaSpent += spend;

					particlesTowards(spark.entity());
				}
				receiver.receiveMana(-manaSpent);
			}
		}

		if (removeTransferants > 0) {
			removeTransferants--;
		}
		filterTransfers();
	}

	private void particlesTowards(class_1297 e) {
		XplatAbstractions.INSTANCE.sendToTracking(this, new BotaniaEffectPacket(EffectType.SPARK_MANA_FLOW, method_23317(), method_23318(), method_23321(),
				method_5628(), e.method_5628(), ColorHelper.getColorValue(getNetwork())));
	}

	public static void particleBeam(class_1657 player, class_1297 e1, class_1297 e2) {
		if (e1 != null && e2 != null && !e1.field_6002.field_9236) {
			XplatAbstractions.INSTANCE.sendToPlayer(player, new BotaniaEffectPacket(EffectType.SPARK_NET_INDICATOR,
					e1.method_23317(), e1.method_23318(), e1.method_23321(),
					e1.method_5628(), e2.method_5628()));
		}
	}

	private void dropAndKill() {
		SparkUpgradeType upgrade = getUpgrade();
		method_5699(new class_1799(BotaniaItems.spark), 0F);
		if (upgrade != SparkUpgradeType.NONE) {
			method_5699(SparkAugmentItem.getByType(upgrade), 0F);
		}
		method_31472();
	}

	@Override
	public class_1269 method_5688(class_1657 player, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (method_5805() && !stack.method_7960()) {
			SparkUpgradeType upgrade = getUpgrade();
			if (stack.method_7909() instanceof WandOfTheForestItem) {
				if (!field_6002.field_9236) {
					if (player.method_5715()) {
						if (upgrade != SparkUpgradeType.NONE) {
							method_5699(SparkAugmentItem.getByType(upgrade), 0F);
							setUpgrade(SparkUpgradeType.NONE);

							transfers.clear();
							removeTransferants = 2;
						} else {
							dropAndKill();
						}
					} else {
						SparkHelper.getSparksAround(field_6002, method_23317(), method_23318() + (method_17682() / 2), method_23321(), getNetwork())
								.forEach(s -> particleBeam(player, this, s.entity()));
					}
				}

				return class_1269.method_29236(field_6002.field_9236);
			} else if (stack.method_7909() instanceof SparkAugmentItem newUpgrade && upgrade == SparkUpgradeType.NONE) {
				if (!field_6002.field_9236) {
					setUpgrade(newUpgrade.type);
					stack.method_7934(1);
				}
				return class_1269.method_29236(field_6002.field_9236);
			} else if (stack.method_31574(BotaniaItems.phantomInk)) {
				if (!field_6002.field_9236) {
					method_5648(true);
				}
				return class_1269.method_29236(field_6002.field_9236);
			} else if (stack.method_7909() instanceof class_1769 dye) {
				class_1767 color = dye.method_7802();
				if (color != getNetwork()) {
					if (!field_6002.field_9236) {
						setNetwork(color);
						stack.method_7934(1);
					}
					return class_1269.method_29236(field_6002.field_9236);
				}
			}
		}

		return class_1269.field_5811;
	}

	@Override
	protected void method_5749(@NotNull class_2487 cmp) {
		super.method_5749(cmp);
		setUpgrade(SparkUpgradeType.values()[cmp.method_10550(TAG_UPGRADE)]);
	}

	@Override
	protected void method_5652(@NotNull class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10569(TAG_UPGRADE, getUpgrade().ordinal());
	}

	@Override
	public SparkAttachable getAttachedTile() {
		return XplatAbstractions.INSTANCE.findSparkAttachable(field_6002, getAttachPos(), field_6002.method_8320(getAttachPos()), field_6002.method_8321(getAttachPos()), class_2350.field_11036);
	}

	private void filterTransfers() {
		Iterator<ManaSpark> iter = transfers.iterator();
		while (iter.hasNext()) {
			ManaSpark spark = iter.next();
			SparkUpgradeType upgr = getUpgrade();
			SparkUpgradeType supgr = spark.getUpgrade();
			ManaReceiver arecv = spark.getAttachedManaReceiver();

			if (spark == this
					|| !((class_1297) spark).method_5805()
					|| spark.areIncomingTransfersDone()
					|| getNetwork() != spark.getNetwork()
					|| arecv == null
					|| arecv.isFull()
					|| !(upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT
							|| upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE)
							|| !(arecv instanceof ManaPool))) {
				iter.remove();
			}
		}
	}

	@Override
	public Collection<ManaSpark> getTransfers() {
		filterTransfers();
		return transfers;
	}

	private boolean hasTransfer(ManaSpark entity) {
		return transfers.contains(entity);
	}

	@Override
	public void registerTransfer(ManaSpark entity) {
		if (hasTransfer(entity)) {
			return;
		}
		transfers.add(entity);
	}

	@Override
	public SparkUpgradeType getUpgrade() {
		return SparkUpgradeType.values()[field_6011.method_12789(UPGRADE)];
	}

	@Override
	public void setUpgrade(SparkUpgradeType upgrade) {
		field_6011.method_12778(UPGRADE, upgrade.ordinal());
	}

	@Override
	public boolean areIncomingTransfersDone() {
		if (getAttachedManaReceiver() instanceof ManaPool) {
			return removeTransferants > 0;
		}

		SparkAttachable attachable = getAttachedTile();
		return attachable != null && attachable.areIncomingTranfersDone();
	}

}
