/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class FallingStarEntity extends ThrowableCopyEntity {

	private static final String TAG_HAS_BEEN_IN_AIR = "hasBeenInAir";
	/*
	* Prevent the star from being discarded on block collisions before its
	* first exposure to an air block.
	*/
	private boolean hasBeenInAir = false;

	public FallingStarEntity(class_1299<FallingStarEntity> type, class_1937 world) {
		super(type, world);
	}

	public FallingStarEntity(class_1309 e, class_1937 world) {
		super(BotaniaEntities.FALLING_STAR, e, world);
	}

	@Override
	protected void method_5693() {}

	@Override
	public void method_5773() {
		super.method_5773();

		if (!hasBeenInAir && !field_6002.field_9236) {
			var bs = method_36601();
			hasBeenInAir = bs.method_26215() || method_5799() || method_5771();
		}

		float dist = 1.5F;
		SparkleParticleData data = SparkleParticleData.sparkle(2F, 1F, 0.4F, 1F, 6);
		for (int i = 0; i < 10; i++) {
			float xs = (float) (Math.random() - 0.5) * dist;
			float ys = (float) (Math.random() - 0.5) * dist;
			float zs = (float) (Math.random() - 0.5) * dist;
			field_6002.method_8494(data, method_23317() + xs, method_23318() + ys, method_23321() + zs, 0, 0, 0);
		}

		class_1297 thrower = method_24921();
		if (!field_6002.field_9236 && thrower != null) {
			class_238 axis = new class_238(method_23317(), method_23318(), method_23321(), field_6038, field_5971, field_5989).method_1014(2);
			List<class_1309> entities = field_6002.method_18467(class_1309.class, axis);
			for (class_1309 living : entities) {
				if (living == thrower) {
					continue;
				}

				if (living.field_6235 == 0) {
					method_7488(new class_3966(living));
					return;
				}
			}
		}

		if (field_6012 > 200) {
			method_31472();
		}
	}

	@Override
	protected void method_7454(@NotNull class_3966 hit) {
		super.method_7454(hit);
		class_1297 e = hit.method_17782();
		// Blacklisting villagers since trading with them counts as a "swing" and will summon a star.
		if (e instanceof class_1646) {
			return;
		}
		if (!field_6002.field_9236) {
			if (e != method_24921() && e.method_5805()) {
				if (method_24921() instanceof class_1657 player) {
					e.method_5643(class_1282.method_5532(player), Math.random() < 0.25 ? 10 : 5);
				} else {
					e.method_5643(class_1282.field_5869, Math.random() < 0.25 ? 10 : 5);
				}
			}
			method_31472();
		}
	}

	@Override
	protected void method_24920(class_3965 hit) {
		super.method_24920(hit);
		if (!field_6002.field_9236) {
			class_2338 bpos = hit.method_17777();
			class_2680 state = field_6002.method_8320(bpos);
			if (hasBeenInAir) {
				if (BotaniaConfig.common().blockBreakParticles() && !state.method_26215()) {
					field_6002.method_20290(2001, bpos, class_2248.method_9507(state));
				}
				method_31472();
			}
		}
	}

	@Override
	protected void method_5652(class_2487 tag) {
		super.method_5652(tag);
		tag.method_10556(TAG_HAS_BEEN_IN_AIR, hasBeenInAir);
	}

	@Override
	protected void method_5749(class_2487 tag) {
		super.method_5749(tag);
		this.hasBeenInAir = tag.method_10577(TAG_HAS_BEEN_IN_AIR);
	}
}
