/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import vazkii.botania.common.block.block_entity.LuminizerBlockEntity.PlayerMoverEntity;
import vazkii.botania.common.lib.LibEntityNames;

import java.util.function.BiConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1528;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public final class BotaniaEntities {
	public static final class_1299<ManaBurstEntity> MANA_BURST = class_1299.class_1300.<ManaBurstEntity>method_5903(
			ManaBurstEntity::new, class_1311.field_17715)
			.method_17687(0, 0)
			.method_27300(10)
			.method_27299(6)
			.method_5905(LibEntityNames.MANA_BURST.toString());
	public static final class_1299<PixieEntity> PIXIE = class_1299.class_1300.<PixieEntity>method_5903(PixieEntity::new, class_1311.field_17715)
			.method_17687(1, 1)
			.method_27300(3)
			.method_27299(6)
			.method_5905(LibEntityNames.PIXIE.toString());
	public static final class_1299<FlameRingEntity> FLAME_RING = class_1299.class_1300.method_5903(FlameRingEntity::new, class_1311.field_17715)
			.method_17687(0, 0)
			.method_27299(3)
			.method_27300(40)
			.method_5905(LibEntityNames.FLAME_RING.toString());
	public static final class_1299<VineBallEntity> VINE_BALL = class_1299.class_1300.<VineBallEntity>method_5903(VineBallEntity::new, class_1311.field_17715)
			.method_17687(0.25F, 0.25F)
			.method_27299(4)
			.method_27300(10)
			.method_5905(LibEntityNames.VINE_BALL.toString());
	public static final class_1299<GaiaGuardianEntity> DOPPLEGANGER = class_1299.class_1300.method_5903(GaiaGuardianEntity::new, class_1311.field_6302)
			.method_17687(0.6F, 1.8F)
			.method_19947()
			.method_27299(10)
			.method_27300(10)
			.method_5905(LibEntityNames.DOPPLEGANGER.toString());
	public static final class_1299<MagicLandmineEntity> MAGIC_LANDMINE = class_1299.class_1300.method_5903(MagicLandmineEntity::new, class_1311.field_17715)
			.method_17687(5F, 0.1F)
			.method_27299(8)
			.method_27300(40)
			.method_5905(LibEntityNames.MAGIC_LANDMINE.toString());
	public static final class_1299<ManaSparkEntity> SPARK = class_1299.class_1300.<ManaSparkEntity>method_5903(ManaSparkEntity::new, class_1311.field_17715)
			.method_17687(0.2F, 0.5F)
			.method_19947()
			.method_27299(4)
			.method_27300(10)
			.method_5905(LibEntityNames.SPARK.toString());
	public static final class_1299<ThrownItemEntity> THROWN_ITEM = class_1299.class_1300.<ThrownItemEntity>method_5903(ThrownItemEntity::new, class_1311.field_17715)
			.method_17687(0.25F, 0.25F)
			.method_27299(4)
			.method_27300(20)
			.method_5905(LibEntityNames.THROWN_ITEM.toString());
	public static final class_1299<MagicMissileEntity> MAGIC_MISSILE = class_1299.class_1300.<MagicMissileEntity>method_5903(MagicMissileEntity::new, class_1311.field_17715)
			.method_17687(0, 0)
			.method_27299(4)
			.method_27300(2)
			.method_5905(LibEntityNames.MAGIC_MISSILE.toString());
	public static final class_1299<ThornChakramEntity> THORN_CHAKRAM = class_1299.class_1300.<ThornChakramEntity>method_5903(ThornChakramEntity::new, class_1311.field_17715)
			.method_17687(0.25F, 0.25F)
			.method_27299(5)
			.method_27300(10)
			.method_5905(LibEntityNames.THORN_CHAKRAM.toString());
	public static final class_1299<CorporeaSparkEntity> CORPOREA_SPARK = class_1299.class_1300.method_5903(CorporeaSparkEntity::new, class_1311.field_17715)
			.method_17687(0.2F, 0.5F)
			.method_19947()
			.method_27299(4)
			.method_27300(40)
			.method_5905(LibEntityNames.CORPOREA_SPARK.toString());
	public static final class_1299<EnderAirBottleEntity> ENDER_AIR_BOTTLE = class_1299.class_1300.<EnderAirBottleEntity>method_5903(EnderAirBottleEntity::new, class_1311.field_17715)
			.method_17687(0.25F, 0.25F)
			.method_27299(4)
			.method_27300(10)
			.method_5905(LibEntityNames.ENDER_AIR_BOTTLE.toString());
	public static final class_1299<ManaPoolMinecartEntity> POOL_MINECART = class_1299.class_1300.<ManaPoolMinecartEntity>method_5903(ManaPoolMinecartEntity::new, class_1311.field_17715)
			.method_17687(0.98F, 0.7F)
			.method_27299(5)
			.method_27300(3)
			.method_5905(LibEntityNames.POOL_MINECART.toString());
	public static final class_1299<PinkWitherEntity> PINK_WITHER = class_1299.class_1300.method_5903(PinkWitherEntity::new, class_1311.field_17715)
			.method_17687(0.9F, 3.5F)
			.method_27299(6)
			.method_27300(3)
			.method_5905(LibEntityNames.PINK_WITHER.toString());
	public static final class_1299<PlayerMoverEntity> PLAYER_MOVER = class_1299.class_1300.<PlayerMoverEntity>method_5903(PlayerMoverEntity::new, class_1311.field_17715)
			.method_17687(0, 0)
			.method_27299(10)
			.method_27300(3)
			.method_5905(LibEntityNames.PLAYER_MOVER.toString());
	public static final class_1299<ManaStormEntity> MANA_STORM = class_1299.class_1300.method_5903(ManaStormEntity::new, class_1311.field_17715)
			.method_17687(0.98F, 0.98F)
			.method_27299(4)
			.method_27300(10)
			.method_5905(LibEntityNames.MANA_STORM.toString());
	public static final class_1299<BabylonWeaponEntity> BABYLON_WEAPON = class_1299.class_1300.<BabylonWeaponEntity>method_5903(BabylonWeaponEntity::new, class_1311.field_17715)
			.method_17687(0, 0)
			.method_27299(6)
			.method_27300(10)
			.method_5905(LibEntityNames.BABYLON_WEAPON.toString());
	public static final class_1299<FallingStarEntity> FALLING_STAR = class_1299.class_1300.<FallingStarEntity>method_5903(FallingStarEntity::new, class_1311.field_17715)
			.method_17687(0, 0)
			.method_27299(4)
			.method_27300(10)
			.method_5905(LibEntityNames.FALLING_STAR.toString());
	public static final class_1299<EnderAirEntity> ENDER_AIR = class_1299.class_1300.method_5903(EnderAirEntity::new, class_1311.field_17715)
			.method_19947()
			.method_17687(1, 1)
			.method_27299(4)
			.method_27300(Integer.MAX_VALUE)
			.method_5905(LibEntityNames.ENDER_AIR.toString());

	public static void registerEntities(BiConsumer<class_1299<?>, class_2960> r) {
		r.accept(MANA_BURST, LibEntityNames.MANA_BURST);
		r.accept(PIXIE, LibEntityNames.PIXIE);
		r.accept(FLAME_RING, LibEntityNames.FLAME_RING);
		r.accept(VINE_BALL, LibEntityNames.VINE_BALL);
		r.accept(DOPPLEGANGER, LibEntityNames.DOPPLEGANGER);
		r.accept(MAGIC_LANDMINE, LibEntityNames.MAGIC_LANDMINE);
		r.accept(SPARK, LibEntityNames.SPARK);
		r.accept(THROWN_ITEM, LibEntityNames.THROWN_ITEM);
		r.accept(MAGIC_MISSILE, LibEntityNames.MAGIC_MISSILE);
		r.accept(THORN_CHAKRAM, LibEntityNames.THORN_CHAKRAM);
		r.accept(CORPOREA_SPARK, LibEntityNames.CORPOREA_SPARK);
		r.accept(ENDER_AIR_BOTTLE, LibEntityNames.ENDER_AIR_BOTTLE);
		r.accept(POOL_MINECART, LibEntityNames.POOL_MINECART);
		r.accept(PINK_WITHER, LibEntityNames.PINK_WITHER);
		r.accept(PLAYER_MOVER, LibEntityNames.PLAYER_MOVER);
		r.accept(MANA_STORM, LibEntityNames.MANA_STORM);
		r.accept(BABYLON_WEAPON, LibEntityNames.BABYLON_WEAPON);
		r.accept(FALLING_STAR, LibEntityNames.FALLING_STAR);
		r.accept(ENDER_AIR, LibEntityNames.ENDER_AIR);
	}

	public static void registerAttributes(BiConsumer<class_1299<? extends class_1309>, class_5132.class_5133> consumer) {
		consumer.accept(BotaniaEntities.DOPPLEGANGER, class_1308.method_26828()
				.method_26868(class_5134.field_23719, 0.4)
				.method_26868(class_5134.field_23716, GaiaGuardianEntity.MAX_HP)
				.method_26868(class_5134.field_23718, 1.0));
		consumer.accept(BotaniaEntities.PIXIE, class_1308.method_26828()
				.method_26868(class_5134.field_23716, 2.0));
		consumer.accept(BotaniaEntities.PINK_WITHER, class_1528.method_26904());
	}
}
