/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

public class TerraShattererTippingRecipe extends class_1852 {
	public static final class_1866<TerraShattererTippingRecipe> SERIALIZER = new class_1866<>(TerraShattererTippingRecipe::new);

	public TerraShattererTippingRecipe(class_2960 id) {
		super(id);
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 world) {
		boolean foundTerraPick = false;
		boolean foundElementiumPick = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof TerraShattererItem
						&& !TerraShattererItem.isTipped(stack) && !foundTerraPick) {
					foundTerraPick = true;
				} else if (stack.method_31574(BotaniaItems.elementiumPick) && !foundElementiumPick) {
					foundElementiumPick = true;
				} else {
					return false; // Found an invalid item, breaking the recipe
				}
			}
		}

		return foundTerraPick && foundElementiumPick;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		class_1799 terraPick = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960() && stack.method_7909() instanceof TerraShattererItem) {
				terraPick = stack;
			}
		}

		if (terraPick.method_7960()) {
			return class_1799.field_8037;
		}

		class_1799 terraPickCopy = terraPick.method_7972();
		TerraShattererItem.setTipped(terraPickCopy);
		return terraPickCopy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}
}
