/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.PureDaisyRecipe;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.common.crafting.StateIngredientHelper;

/**
 * Recipe that copies state properties to the new block on crafting.
 */
public class StateCopyingPureDaisyRecipe extends PureDaisyRecipe {
	public StateCopyingPureDaisyRecipe(class_2960 id, StateIngredient input, class_2248 block, int time) {
		super(id, input, block.method_9564(), time, class_2158.class_2159.field_9809);
	}

	@Override
	public boolean matches(class_1937 world, class_2338 pos, SpecialFlowerBlockEntity pureDaisy, class_2680 state) {
		return input.test(state) && outputState.method_26204().method_34725(state) != state;
	}

	@Override
	public boolean set(class_1937 world, class_2338 pos, SpecialFlowerBlockEntity pureDaisy) {
		if (!world.field_9236) {
			class_2248 block = getOutputState().method_26204();
			world.method_8501(pos, block.method_34725(world.method_8320(pos)));
		}
		return true;
	}

	public static class Serializer extends RecipeSerializerBase<StateCopyingPureDaisyRecipe> {
		@NotNull
		@Override
		public StateCopyingPureDaisyRecipe method_8121(@NotNull class_2960 id, JsonObject object) {
			StateIngredient input = StateIngredientHelper.deserialize(class_3518.method_15296(object, "input"));
			class_2960 blockId = new class_2960(class_3518.method_15265(object, "output"));
			class_2248 output = class_2378.field_11146.method_17966(blockId)
					.orElseThrow(() -> new JsonSyntaxException("Unknown block id: " + blockId));

			int time = class_3518.method_15282(object, "time", DEFAULT_TIME);
			return new StateCopyingPureDaisyRecipe(id, input, output, time);
		}

		@Override
		public void toNetwork(@NotNull class_2540 buf, StateCopyingPureDaisyRecipe recipe) {
			recipe.getInput().write(buf);
			buf.method_10804(class_2378.field_11146.method_10206(recipe.getOutputState().method_26204()));
			buf.method_10804(recipe.getTime());
		}

		@Nullable
		@Override
		public StateCopyingPureDaisyRecipe method_8122(@NotNull class_2960 id, @NotNull class_2540 buf) {
			StateIngredient input = StateIngredientHelper.read(buf);
			class_2248 output = class_2378.field_11146.method_10200(buf.method_10816());
			int time = buf.method_10816();
			return new StateCopyingPureDaisyRecipe(id, input, output, time);
		}
	}
}
