/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.item.BotaniaItems;

public class SpellbindingClothRecipe extends class_1852 {
	public static final class_1866<SpellbindingClothRecipe> SERIALIZER = new class_1866<>(SpellbindingClothRecipe::new);

	public SpellbindingClothRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 world) {
		boolean foundCloth = false;
		boolean foundEnchanted = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7942() && !foundEnchanted) {
					foundEnchanted = true;
				} else if (stack.method_31574(BotaniaItems.spellCloth) && !foundCloth) {
					foundCloth = true;
				} else {
					return false; // Found an invalid item, breaking the recipe
				}
			}
		}

		return foundCloth && foundEnchanted;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		class_1799 stackToDisenchant = class_1799.field_8037;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960() && stack.method_7942() && !stack.method_31574(BotaniaItems.spellCloth)) {
				stackToDisenchant = stack.method_7972();
				stackToDisenchant.method_7939(1);
				break;
			}
		}

		if (stackToDisenchant.method_7960()) {
			return class_1799.field_8037;
		}

		stackToDisenchant.method_7983("Enchantments"); // Remove enchantments
		stackToDisenchant.method_7983("RepairCost");
		return stackToDisenchant;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	@NotNull
	@Override
	public class_2371<class_1799> getRemainingItems(@NotNull class_1715 inv) {
		return RecipeUtils.getRemainingItemsSub(inv, s -> {
			if (s.method_31574(BotaniaItems.spellCloth)) {
				class_1799 copy = s.method_7972();
				copy.method_7939(1);
				copy.method_7974(copy.method_7919() + 1);
				return copy;
			}
			return null;
		});
	}
}
