/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ResoluteIvyItem;

public class ResoluteIvyRecipe extends class_1852 {
	public static final class_1866<ResoluteIvyRecipe> SERIALIZER = new class_1866<>(ResoluteIvyRecipe::new);

	public ResoluteIvyRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 world) {
		boolean foundIvy = false;
		boolean foundItem = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_31574(BotaniaItems.keepIvy) && !foundIvy) {
					foundIvy = true;
				} else if (!foundItem
						&& !(stack.method_7985() && ItemNBTHelper.getBoolean(stack, ResoluteIvyItem.TAG_KEEP, false))
						&& !stack.method_7909().method_7857()) {
					foundItem = true;
				} else {
					return false;
				}
			}
		}

		return foundIvy && foundItem;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		class_1799 item = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960() && !stack.method_31574(BotaniaItems.keepIvy)) {
				item = stack;
			}
		}

		class_1799 copy = item.method_7972();
		ItemNBTHelper.setBoolean(copy, ResoluteIvyItem.TAG_KEEP, true);
		copy.method_7939(1);
		return copy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
