/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.crafting.RecipeSerializerBase;

public class NbtOutputRecipe {
	public static final class_1865<class_1860<?>> SERIALIZER = new NbtOutputRecipe.Serializer();

	private static class Serializer extends RecipeSerializerBase<class_1860<?>> {
		@NotNull
		@Override
		public class_1860<?> method_8121(@NotNull class_2960 resourceLocation, @NotNull JsonObject jsonObject) {
			var recipe = class_1863.method_17720(resourceLocation, class_3518.method_15296(jsonObject, "recipe"));
			JsonElement nbt = jsonObject.get("nbt");

			if (nbt == null) {
				throw new JsonSyntaxException("No nbt tag");
			}
			try {
				class_2487 tag = class_2522.method_10718(class_3518.method_15287(nbt, "nbt"));
				recipe.method_8110().method_7980(tag);
			} catch (CommandSyntaxException e) {
				throw new JsonSyntaxException("Invalid nbt tag: " + e.getMessage(), e);
			}
			return recipe;
		}

		@NotNull
		@Override
		public class_1860<?> method_8122(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
			throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
		}

		@Override
		public void method_8124(@NotNull class_2540 buffer, @NotNull class_1860<?> recipe) {
			throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
		}
	}
}
