/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.item.brew.BaseBrewItem;

import java.util.Objects;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

public class MergeVialRecipe extends class_1852 {
	public static final class_1866<MergeVialRecipe> SERIALIZER = new class_1866<>(MergeVialRecipe::new);

	public MergeVialRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(class_1715 inv, @NotNull class_1937 worldIn) {
		int count = 0;
		Brew brew = null;

		for (int i = 0; i < inv.method_5439(); ++i) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_7960()) {
				continue;
			}

			if (!(stack.method_7909() instanceof BaseBrewItem vial)) {
				return false;
			}

			if (brew == null) {
				brew = vial.getBrew(stack);
			} else if (brew != vial.getBrew(stack)) {
				return false;
			}
			count++;
		}

		return count > 1;
	}

	@NotNull
	@Override
	public class_1799 assemble(class_1715 inv) {
		class_1799 firstStack = class_1799.field_8037;
		BaseBrewItem brew = null;
		int swigs = 0;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_7960()) {
				continue;
			}

			if (brew == null) {
				firstStack = stack.method_7972();
				brew = ((BaseBrewItem) stack.method_7909());
			}
			swigs += brew.getSwigsLeft(stack);
			if (swigs >= brew.getSwigs()) {
				swigs = brew.getSwigs();
				break;
			}
		}

		Objects.requireNonNull(brew).setSwigsLeft(firstStack, swigs);
		return firstStack;
	}

	@Override
	public class_2371<class_1799> getRemainingItems(class_1715 inv) {
		class_2371<class_1799> remaining = class_2371.method_10213(inv.method_5439(), class_1799.field_8037);

		boolean foundFirst = false;
		int swigs = 0;
		int maxSwigs = 0;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_7960()) {
				continue;
			}

			BaseBrewItem brew = ((BaseBrewItem) stack.method_7909());
			if (!foundFirst) {
				foundFirst = true;
				swigs = brew.getSwigsLeft(stack);
				maxSwigs = brew.getSwigs();
				continue;
			}

			swigs += brew.getSwigsLeft(stack);
			if (swigs > maxSwigs) {
				brew.setSwigsLeft(stack, swigs - maxSwigs);
				swigs = maxSwigs;
				remaining.set(i, stack.method_7972());
			} else {
				remaining.set(i, brew.getBaseStack());
			}
		}

		return remaining;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height > 2;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
