/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.class_1263;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaUpgradeRecipe extends class_1869 {
	public ManaUpgradeRecipe(class_1869 compose) {
		super(compose.method_8114(), compose.method_8112(), compose.method_8150(), compose.method_8158(), compose.method_8117(), compose.method_8110());
	}

	public static class_1799 output(class_1799 output, class_1263 inv) {
		class_1799 out = output.method_7972();
		var outItem = XplatAbstractions.INSTANCE.findManaItem(out);
		if (outItem == null) {
			return out;
		}
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			var item = XplatAbstractions.INSTANCE.findManaItem(stack);
			if (!stack.method_7960() && item != null) {
				outItem.addMana(item.getMana());
			}
		}
		return out;
	}

	@NotNull
	@Override
	public class_1799 method_17727(@NotNull class_1715 inv) {
		return output(super.method_17727(inv), inv);
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	public static final class_1865<ManaUpgradeRecipe> SERIALIZER = new Serializer();

	private static class Serializer extends RecipeSerializerBase<ManaUpgradeRecipe> {
		@Override
		public ManaUpgradeRecipe method_8121(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
			return new ManaUpgradeRecipe(field_9035.method_8121(recipeId, json));
		}

		@Override
		public ManaUpgradeRecipe method_8122(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
			return new ManaUpgradeRecipe(field_9035.method_8122(recipeId, buffer));
		}

		@Override
		public void toNetwork(@NotNull class_2540 buffer, @NotNull ManaUpgradeRecipe recipe) {
			field_9035.method_8124(buffer, recipe);
		}
	}
}
