/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterLensRecipe extends class_1852 {
	public static final class_1866<ManaBlasterLensRecipe> SERIALIZER = new class_1866<>(ManaBlasterLensRecipe::new);

	public ManaBlasterLensRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 world) {
		int foundLens = 0;
		int foundGun = 0;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ManaBlasterItem && ManaBlasterItem.getLens(stack).method_7960()) {
					foundGun++;
				} else if (ManaBlasterItem.isValidLens(stack)) {
					foundLens++;
				} else {
					return false; // Found an invalid item, breaking the recipe
				}
			}
		}

		return foundLens == 1 && foundGun == 1;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		class_1799 lens = class_1799.field_8037;
		class_1799 gun = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof ManaBlasterItem) {
					gun = stack;
				} else if (stack.method_7909() instanceof BasicLensItem) {
					lens = stack.method_7972();
					lens.method_7939(1);
				}
			}
		}

		if (lens.method_7960() || gun.method_7960()) {
			return class_1799.field_8037;
		}

		class_1799 gunCopy = gun.method_7972();
		ManaBlasterItem.setLens(gunCopy, lens);

		return gunCopy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
