/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.common.base.Suppliers;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class LensDyeingRecipe extends class_1852 {
	public static final class_1866<LensDyeingRecipe> SERIALIZER = new class_1866<>(LensDyeingRecipe::new);

	private final Supplier<List<class_1856>> dyes = Suppliers.memoize(() -> Arrays.asList(
			class_1856.method_8091(class_1802.field_8446), class_1856.method_8091(class_1802.field_8492),
			class_1856.method_8091(class_1802.field_8669), class_1856.method_8091(class_1802.field_8273),
			class_1856.method_8091(class_1802.field_8192), class_1856.method_8091(class_1802.field_8131),
			class_1856.method_8091(class_1802.field_8330), class_1856.method_8091(class_1802.field_8298),
			class_1856.method_8091(class_1802.field_8851), class_1856.method_8091(class_1802.field_8632),
			class_1856.method_8091(class_1802.field_8296), class_1856.method_8091(class_1802.field_8345),
			class_1856.method_8091(class_1802.field_8099), class_1856.method_8091(class_1802.field_8408),
			class_1856.method_8091(class_1802.field_8264), class_1856.method_8091(class_1802.field_8226),
			class_1856.method_8091(BotaniaItems.manaPearl)
	));

	public LensDyeingRecipe(class_2960 id) {
		super(id);
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 world) {
		boolean foundLens = false;
		boolean foundDye = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof BasicLensItem && !foundLens) {
					foundLens = true;
				} else if (!foundDye) {
					int color = getStackColor(stack);
					if (color > -1) {
						foundDye = true;
					} else {
						return false;
					}
				} else {
					return false;//This means we have an additional item in the recipe after the lens and dye
				}
			}
		}

		return foundLens && foundDye;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		class_1799 lens = class_1799.field_8037;
		int color = -1;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof BasicLensItem && lens.method_7960()) {
					lens = stack;
				} else {
					color = getStackColor(stack);//We can assume if its not a lens its a dye because we checked it in matches()
				}
			}
		}

		if (lens.method_7909() instanceof BasicLensItem) {
			class_1799 lensCopy = lens.method_7972();
			lensCopy.method_7939(1);
			LensItem.setLensColor(lensCopy, color);

			return lensCopy;
		}

		return class_1799.field_8037;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	private int getStackColor(class_1799 stack) {
		List<class_1856> dyes = this.dyes.get();
		for (int i = 0; i < dyes.size(); i++) {
			if (dyes.get(i).method_8093(stack)) {
				return i;
			}
		}

		return -1;
	}
}
