/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LaputaShardItem;

public class LaputaShardUpgradeRecipe extends class_1852 {
	public static final class_1866<LaputaShardUpgradeRecipe> SERIALIZER = new class_1866<>(LaputaShardUpgradeRecipe::new);

	public LaputaShardUpgradeRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 worldIn) {
		boolean foundShard = false;
		boolean foundSpirit = false;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_7960()) {
				continue;
			}
			if (stack.method_31574(BotaniaItems.laputaShard) && !foundShard
					&& LaputaShardItem.getShardLevel(stack) < 19) {
				foundShard = true;
			} else if (stack.method_31574(BotaniaItems.lifeEssence) && !foundSpirit) {
				foundSpirit = true;
			} else {
				return false;
			}
		}
		return foundShard && foundSpirit;
	}

	@NotNull
	@Override
	public class_1799 method_8110() {
		return new class_1799(BotaniaItems.laputaShard);
	}

	@NotNull
	@Override
	public class_2371<class_1856> method_8117() {
		return class_2371.method_10212(class_1856.field_9017,
				class_1856.method_8091(BotaniaItems.laputaShard),
				class_1856.method_8091(BotaniaItems.lifeEssence));
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (stack.method_31574(BotaniaItems.laputaShard)) {
				class_1799 result = stack.method_7972();
				result.method_7948().method_10569(LaputaShardItem.TAG_LEVEL, LaputaShardItem.getShardLevel(stack) + 1);
				return result;
			}
		}
		return class_1799.field_8037;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 2;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
