/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.xplat.XplatAbstractions;

public class GogAlternationRecipe {
	public static final class_1865<class_1860<?>> SERIALIZER = new Serializer();

	private static class Serializer extends RecipeSerializerBase<class_1860<?>> {
		@NotNull
		@Override
		public class_1860<?> method_8121(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
			// just select the recipe here
			class_1860<?> gog = class_1863.method_17720(recipeId, class_3518.method_15296(json, "gog"));
			class_1860<?> base = class_1863.method_17720(recipeId, class_3518.method_15296(json, "base"));

			if (gog.method_17716() != base.method_17716()) {
				throw new IllegalArgumentException("Subrecipes must have matching types");
			}

			if (XplatAbstractions.INSTANCE.gogLoaded()) {
				return gog;
			} else {
				return base;
			}
		}

		@NotNull
		@Override
		public class_1860<?> method_8122(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
			throw new IllegalStateException("GogAlternationRecipe should not be sent over network");
		}

		@Override
		public void method_8124(@NotNull class_2540 buffer, @NotNull class_1860<?> recipe) {
			throw new IllegalStateException("GogAlternationRecipe should not be sent over network");
		}
	}
}
