/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class CosmeticRemoveRecipe extends class_1852 {
	public static final class_1866<CosmeticRemoveRecipe> SERIALIZER = new class_1866<>(CosmeticRemoveRecipe::new);

	public CosmeticRemoveRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 world) {
		boolean foundAttachable = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof CosmeticAttachable attachable && !(stack.method_7909() instanceof CosmeticBauble) && !attachable.getCosmeticItem(stack).method_7960()) {
					foundAttachable = true;
				} else {
					return false;
				}
			}
		}

		return foundAttachable;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		class_1799 attachableItem = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				attachableItem = stack;
			}
		}

		CosmeticAttachable attachable = (CosmeticAttachable) attachableItem.method_7909();
		if (attachable.getCosmeticItem(attachableItem).method_7960()) {
			return class_1799.field_8037;
		}

		class_1799 copy = attachableItem.method_7972();
		copy.method_7939(1);
		attachable.setCosmeticItem(copy, class_1799.field_8037);
		return copy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height > 0;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	@NotNull
	@Override
	public class_2371<class_1799> getRemainingItems(@NotNull class_1715 inv) {
		return RecipeUtils.getRemainingItemsSub(inv, s -> {
			if (s.method_7909() instanceof BaubleItem bauble) {
				class_1799 stack = bauble.getCosmeticItem(s);
				stack.method_7939(1);
				return stack;
			}
			return null;
		});
	}
}
