/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;

public class BlackHoleTalismanExtractRecipe extends class_1852 {
	public static final class_1866<BlackHoleTalismanExtractRecipe> SERIALIZER = new class_1866<>(BlackHoleTalismanExtractRecipe::new);

	public BlackHoleTalismanExtractRecipe(class_2960 id) {
		super(id);
	}

	@Override
	public boolean matches(@NotNull class_1715 inv, @NotNull class_1937 world) {
		boolean foundTalisman = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_31574(BotaniaItems.blackHoleTalisman) && !foundTalisman) {

					// Avoid returning true for empty talismans
					int count = BlackHoleTalismanItem.getBlockCount(stack);
					if (count <= 0) {
						return false;
					}

					foundTalisman = true;
				} else {
					return false;
				}
			}
		}

		return foundTalisman;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_1715 inv) {
		class_1799 talisman = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				talisman = stack;
			}
		}

		int count = BlackHoleTalismanItem.getBlockCount(talisman);
		if (count > 0) {
			class_2248 block = BlackHoleTalismanItem.getBlock(talisman);
			if (block != null) {
				return new class_1799(block, Math.min(64, count));
			}
		}

		return class_1799.field_8037;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height > 0;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	@NotNull
	@Override
	public class_2371<class_1799> getRemainingItems(@NotNull class_1715 inv) {
		return RecipeUtils.getRemainingItemsSub(inv, s -> {
			if (s.method_31574(BotaniaItems.blackHoleTalisman)) {
				int count = BlackHoleTalismanItem.getBlockCount(s);
				if (count == 0) {
					return class_1799.field_8037;
				}

				int extract = Math.min(64, count);
				class_1799 copy = s.method_7972();
				copy.method_7939(1);
				BlackHoleTalismanItem.remove(copy, extract);
				ItemNBTHelper.setBoolean(copy, BlackHoleTalismanItem.TAG_ACTIVE, false);

				return copy;
			}
			return null;
		});
	}
}
