/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class TagStateIngredient extends BlocksStateIngredient {
	private final class_6862<class_2248> tag;

	public TagStateIngredient(class_2960 tag) {
		super(ImmutableSet.of());
		this.tag = class_6862.method_40092(class_2378.field_25105, tag);
	}

	public Stream<class_2248> resolve() {
		return StreamSupport.stream(class_2378.field_11146.method_40286(tag).spliterator(), false)
				.map(class_6880::comp_349);
	}

	@Override
	public boolean test(class_2680 state) {
		return state.method_26164(tag);
	}

	@Override
	public class_2680 pick(class_5819 random) {
		var values = resolve().toList();
		if (values.isEmpty()) {
			return null;
		}
		return values.get(random.method_43048(values.size())).method_9564();
	}

	@Override
	public JsonObject serialize() {
		JsonObject object = new JsonObject();
		object.addProperty("type", "tag");
		object.addProperty("tag", tag.comp_327().toString());
		return object;
	}

	@Override
	public List<class_1799> getDisplayedStacks() {
		return resolve()
				.filter(b -> b.method_8389() != class_1802.field_8162)
				.map(class_1799::new)
				.collect(Collectors.toList());
	}

	@NotNull
	@Override
	public List<class_2248> getBlocks() {
		return resolve().toList();
	}

	@Override
	public List<class_2680> getDisplayed() {
		return resolve().map(class_2248::method_9564).collect(Collectors.toList());
	}

	public class_2960 getTagId() {
		return tag.comp_327();
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		return tag.equals(((TagStateIngredient) o).tag);
	}

	@Override
	public int hashCode() {
		return tag.hashCode();
	}

	@Override
	public String toString() {
		return "TagStateIngredient{" + tag + "}";
	}
}
