/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RecipeTerraPlate implements TerrestrialAgglomerationRecipe {
	private final class_2960 id;
	private final int mana;
	private final class_2371<class_1856> inputs;
	private final class_1799 output;

	public RecipeTerraPlate(class_2960 id, int mana, class_2371<class_1856> inputs, class_1799 output) {
		this.id = id;
		this.mana = mana;
		this.inputs = inputs;
		this.output = output;
	}

	@Override
	public int getMana() {
		return mana;
	}

	@Override
	public boolean method_8115(class_1263 inv, @NotNull class_1937 world) {
		int nonEmptySlots = 0;
		for (int i = 0; i < inv.method_5439(); i++) {
			if (!inv.method_5438(i).method_7960()) {
				if (inv.method_5438(i).method_7947() > 1) {
					return false;
				}
				nonEmptySlots++;
			}
		}

		IntOpenHashSet usedSlots = new IntOpenHashSet(inv.method_5439());
		return RecipeUtils.matches(inputs, inv, usedSlots) && usedSlots.size() == nonEmptySlots;
	}

	@NotNull
	@Override
	public class_1799 method_8116(@NotNull class_1263 inv) {
		return output.method_7972();
	}

	@NotNull
	@Override
	public class_1799 method_8110() {
		return output;
	}

	@NotNull
	@Override
	public class_2371<class_1856> method_8117() {
		return inputs;
	}

	@NotNull
	@Override
	public class_2960 method_8114() {
		return id;
	}

	@NotNull
	@Override
	public class_1865<RecipeTerraPlate> method_8119() {
		return BotaniaRecipeTypes.TERRA_PLATE_SERIALIZER;
	}

	public static class Serializer extends RecipeSerializerBase<RecipeTerraPlate> {
		@NotNull
		@Override
		public RecipeTerraPlate method_8121(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
			int mana = class_3518.method_15260(json, "mana");
			JsonArray ingrs = class_3518.method_15261(json, "ingredients");
			class_1856[] ingredients = new class_1856[ingrs.size()];
			for (int i = 0; i < ingrs.size(); i++) {
				ingredients[i] = class_1856.method_8102(ingrs.get(i));
			}
			class_1799 output = class_1869.method_35228(class_3518.method_15296(json, "result"));
			return new RecipeTerraPlate(recipeId, mana, class_2371.method_10212(class_1856.field_9017, ingredients), output);
		}

		@Override
		public RecipeTerraPlate method_8122(@NotNull class_2960 recipeId, class_2540 buffer) {
			int mana = buffer.method_10816();
			class_1856[] ingredients = new class_1856[buffer.method_10816()];
			for (int i = 0; i < ingredients.length; i++) {
				ingredients[i] = class_1856.method_8086(buffer);
			}
			class_1799 output = buffer.method_10819();
			return new RecipeTerraPlate(recipeId, mana, class_2371.method_10212(class_1856.field_9017, ingredients), output);
		}

		@Override
		public void toNetwork(class_2540 buffer, RecipeTerraPlate recipe) {
			buffer.method_10804(recipe.mana);
			buffer.method_10804(recipe.method_8117().size());
			for (class_1856 ingr : recipe.method_8117()) {
				ingr.method_8088(buffer);
			}
			buffer.method_10793(recipe.output);
		}
	}
}
