/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import I;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1865;
import net.minecraft.class_2158;
import net.minecraft.class_2158.class_2159;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.StateIngredient;

public class OrechidRecipe implements vazkii.botania.api.recipe.OrechidRecipe {
	private final class_2960 id;
	private final StateIngredient input;
	private final StateIngredient output;
	private final int weight;
	private final class_2158.class_2159 successFunction;

	public OrechidRecipe(class_2960 id, StateIngredient input, StateIngredient output, int weight, class_2158.class_2159 successFunction) {
		this.id = id;
		this.input = input;
		this.output = output;
		this.weight = weight;
		this.successFunction = successFunction;
	}

	@Override
	public StateIngredient getInput() {
		return input;
	}

	@Override
	public StateIngredient getOutput() {
		return output;
	}

	@Override
	public int getWeight() {
		return weight;
	}

	@Override
	public class_2158.class_2159 getSuccessFunction() {
		return this.successFunction;
	}

	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Override
	public class_3956<?> method_17716() {
		return BotaniaRecipeTypes.ORECHID_TYPE;
	}

	@Override
	public class_1865<?> method_8119() {
		return BotaniaRecipeTypes.ORECHID_SERIALIZER;
	}

	public static class Serializer extends RecipeSerializerBase<OrechidRecipe> {
		@Override
		public OrechidRecipe method_8121(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
			var input = StateIngredientHelper.tryDeserialize(class_3518.method_15296(json, "input"));
			if (input == null) {
				throw new JsonSyntaxException("Unknown input: " + class_3518.method_15296(json, "input"));
			}
			var output = StateIngredientHelper.tryDeserialize(class_3518.method_15296(json, "output"));
			if (output == null) {
				throw new JsonSyntaxException("Unknown output: " + class_3518.method_15296(json, "output"));
			}
			var weight = class_3518.method_15260(json, "weight");
			var functionIdString = class_3518.method_15253(json, "success_function", null);
			var functionId = functionIdString == null ? null : new class_2960(functionIdString);
			var function = functionId == null
					? class_2158.class_2159.field_9809
					: new class_2158.class_2159(functionId);

			return new OrechidRecipe(recipeId, input, output, weight, function);
		}

		@Override
		public OrechidRecipe method_8122(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
			var input = StateIngredientHelper.read(buffer);
			var output = StateIngredientHelper.read(buffer);
			var weight = buffer.method_10816();
			return new OrechidRecipe(recipeId, input, output, weight, class_2158.class_2159.field_9809);
		}

		@Override
		public void toNetwork(@NotNull class_2540 buffer, @NotNull OrechidRecipe recipe) {
			recipe.getInput().write(buffer);
			recipe.getOutput().write(buffer);
			buffer.method_10804(recipe.getWeight());
		}
	}
}
