/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import net.minecraft.class_1865;
import net.minecraft.class_2158;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.StateIngredient;

public class OrechidIgnemRecipe extends OrechidRecipe {
	public OrechidIgnemRecipe(class_2960 id, StateIngredient input, StateIngredient output, int weight, class_2158.class_2159 successFunction) {
		super(id, input, output, weight, successFunction);
	}

	private OrechidIgnemRecipe(OrechidRecipe recipe) {
		this(recipe.method_8114(), recipe.getInput(), recipe.getOutput(), recipe.getWeight(), recipe.getSuccessFunction());
	}

	@Override
	public class_3956<?> method_17716() {
		return BotaniaRecipeTypes.ORECHID_IGNEM_TYPE;
	}

	@Override
	public class_1865<?> method_8119() {
		return BotaniaRecipeTypes.ORECHID_IGNEM_SERIALIZER;
	}

	public static class Serializer extends RecipeSerializerBase<OrechidIgnemRecipe> {
		@Override
		public OrechidIgnemRecipe method_8121(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
			return new OrechidIgnemRecipe(BotaniaRecipeTypes.ORECHID_SERIALIZER.method_8121(recipeId, json));
		}

		@Override
		public OrechidIgnemRecipe method_8122(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
			return new OrechidIgnemRecipe(BotaniaRecipeTypes.ORECHID_SERIALIZER.method_8122(recipeId, buffer));
		}

		@Override
		public void toNetwork(@NotNull class_2540 buffer, @NotNull OrechidIgnemRecipe recipe) {
			BotaniaRecipeTypes.ORECHID_SERIALIZER.method_8124(buffer, recipe);
		}
	}
}
