/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.red_string;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.red_string.RedStringBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringNutrifierBlockEntity;

public class RedStringNutrifierBlock extends RedStringBlock implements class_2256 {

	public RedStringNutrifierBlock(class_4970.class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12525, class_2350.field_11033));
	}

	@Override
	public boolean method_9651(@NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_2680 state, boolean isClient) {
		return ((RedStringNutrifierBlockEntity) world.method_8321(pos)).canGrow(world, isClient);
	}

	@Override
	public boolean method_9650(@NotNull class_1937 world, @NotNull class_5819 rand, @NotNull class_2338 pos, @NotNull class_2680 state) {
		return ((RedStringNutrifierBlockEntity) world.method_8321(pos)).canUseBonemeal(world, rand);
	}

	@Override
	public void method_9652(@NotNull class_3218 world, @NotNull class_5819 rand, @NotNull class_2338 pos, @NotNull class_2680 state) {
		((RedStringNutrifierBlockEntity) world.method_8321(pos)).grow(world, rand);
	}

	@NotNull
	@Override
	public RedStringBlockEntity method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new RedStringNutrifierBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.RED_STRING_FERTILIZER, RedStringNutrifierBlockEntity::commonTick);
	}
}
