/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.OpenCrateBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.SpreaderTurntableBlockEntity;

public class SpreaderTurntableBlock extends BotaniaBlock implements class_2343 {

	public SpreaderTurntableBlock(class_2251 builder) {
		super(builder);
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new SpreaderTurntableBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.TURNTABLE, SpreaderTurntableBlockEntity::commonTick);
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		if (world.method_8479(pos) && rand.method_43058() < 0.2) {
			OpenCrateBlock.redstoneParticlesOnFullBlock(world, pos, rand);
		}
	}
}
