/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.WandOfTheForestItem;

public class ManaSpreaderBlock extends BotaniaWaterloggedBlock implements class_2343 {
	private static final class_265 SHAPE = method_9541(2, 2, 2, 14, 14, 14);
	private static final class_265 SHAPE_PADDING = method_9541(1, 1, 1, 15, 15, 15);
	private static final class_265 SHAPE_SCAFFOLDING = method_9541(0, 0, 0, 16, 16, 16);

	public enum Variant {
		MANA(160, 1000, 0x20FF20, 0x00FF00, 60, 4f, 1f),
		REDSTONE(160, 1000, 0xFF2020, 0xFF0000, 60, 4f, 1f),
		ELVEN(240, 1000, 0xFF45C4, 0xFF00AE, 80, 4f, 1.25f),
		GAIA(640, 6400, 0x20FF20, 0x00FF00, 120, 20f, 2f);

		public final int burstMana;
		public final int manaCapacity;
		public final int color;
		public final int hudColor;
		public final int preLossTicks;
		public final float lossPerTick;
		public final float motionModifier;

		Variant(int bm, int mc, int c, int hc, int plt, float lpt, float mm) {
			burstMana = bm;
			manaCapacity = mc;
			color = c;
			hudColor = hc;
			preLossTicks = plt;
			lossPerTick = lpt;
			motionModifier = mm;
		}
	}

	public final Variant variant;

	public ManaSpreaderBlock(Variant v, class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(BotaniaStateProperties.HAS_SCAFFOLDING, false));
		this.variant = v;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(BotaniaStateProperties.HAS_SCAFFOLDING);
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
		if (blockState.method_11654(BotaniaStateProperties.HAS_SCAFFOLDING)) {
			return SHAPE_SCAFFOLDING;
		}
		class_2586 be = blockGetter.method_8321(blockPos);
		return be instanceof ManaSpreaderBlockEntity spreader && spreader.paddingColor != null ? SHAPE_PADDING : SHAPE;
	}

	@NotNull
	@Override
	public class_265 method_9571(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos) {
		return SHAPE;
	}

	@Override
	public float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
		return 1.0F;
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
		class_2350 orientation = placer == null ? class_2350.field_11039 : class_2350.method_10159(placer)[0].method_10153();
		ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity) world.method_8321(pos);

		switch (orientation) {
			case field_11033:
				spreader.rotationY = -90F;
				break;
			case field_11036:
				spreader.rotationY = 90F;
				break;
			case field_11043:
				spreader.rotationX = 270F;
				break;
			case field_11035:
				spreader.rotationX = 90F;
				break;
			case field_11039:
				break;
			case field_11034:
				spreader.rotationX = 180F;
				break;
		}
	}

	@NotNull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_2586 tile = world.method_8321(pos);
		if (!(tile instanceof ManaSpreaderBlockEntity spreader)) {
			return class_1269.field_5811;
		}

		class_1799 heldItem = player.method_5998(hand);
		if (heldItem.method_7909() instanceof WandOfTheForestItem) {
			return class_1269.field_5811;
		}
		boolean mainHandEmpty = player.method_6047().method_7960();

		class_1799 lens = spreader.getItemHandler().method_5438(0);
		boolean playerHasLens = heldItem.method_7909() instanceof BasicLensItem;
		boolean lensIsSame = playerHasLens && class_1799.method_31577(heldItem, lens);
		class_1799 wool = spreader.paddingColor != null
				? new class_1799(ColorHelper.WOOL_MAP.apply(spreader.paddingColor))
				: class_1799.field_8037;
		boolean playerHasWool = ColorHelper.isWool(class_2248.method_9503(heldItem.method_7909()));
		boolean woolIsSame = playerHasWool && class_1799.method_31577(heldItem, wool);
		boolean playerHasScaffolding = !heldItem.method_7960() && heldItem.method_31574(class_1802.field_16482);
		boolean shouldInsert = (playerHasLens && !lensIsSame)
				|| (playerHasWool && !woolIsSame)
				|| (playerHasScaffolding && !state.method_11654(BotaniaStateProperties.HAS_SCAFFOLDING));

		if (shouldInsert) {
			if (playerHasLens) {
				class_1799 toInsert = heldItem.method_7972();
				toInsert.method_7939(1);

				heldItem.method_7934(1);
				if (!lens.method_7960()) {
					player.method_31548().method_7398(lens);
				}

				spreader.getItemHandler().method_5447(0, toInsert);
				world.method_8396(player, pos, BotaniaSounds.spreaderAddLens, class_3419.field_15245, 1F, 1F);
			} else if (playerHasWool) {
				class_2248 woolBlock = class_2248.method_9503(heldItem.method_7909());

				heldItem.method_7934(1);
				if (spreader.paddingColor != null) {
					class_1799 spreaderWool = new class_1799(ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
					player.method_31548().method_7398(spreaderWool);
				}

				spreader.paddingColor = ColorHelper.getWoolColor(woolBlock);
				spreader.method_5431();
				world.method_8396(player, pos, BotaniaSounds.spreaderCover, class_3419.field_15245, 1F, 1F);
			} else { // playerHasScaffolding
				world.method_8501(pos, state.method_11657(BotaniaStateProperties.HAS_SCAFFOLDING, true));
				world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));

				if (!player.method_31549().field_7477) {
					heldItem.method_7934(1);
				}

				world.method_8396(player, pos, BotaniaSounds.spreaderScaffold, class_3419.field_15245, 1F, 1F);
			}
			return class_1269.method_29236(world.method_8608());
		}

		if (state.method_11654(BotaniaStateProperties.HAS_SCAFFOLDING) && player.method_21823()) {
			if (!player.method_31549().field_7477) {
				class_1799 scaffolding = new class_1799(class_1802.field_16482);
				player.method_31548().method_7398(scaffolding);
			}
			world.method_8501(pos, state.method_11657(BotaniaStateProperties.HAS_SCAFFOLDING, false));
			world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));

			world.method_8396(player, pos, BotaniaSounds.spreaderUnScaffold, class_3419.field_15245, 1F, 1F);

			return class_1269.method_29236(world.method_8608());
		}
		if (!lens.method_7960() && (mainHandEmpty || lensIsSame)) {
			player.method_31548().method_7398(lens);
			spreader.getItemHandler().method_5447(0, class_1799.field_8037);

			world.method_8396(player, pos, BotaniaSounds.spreaderRemoveLens, class_3419.field_15245, 1F, 1F);

			return class_1269.method_29236(world.method_8608());
		}
		if (spreader.paddingColor != null && (mainHandEmpty || woolIsSame)) {
			player.method_31548().method_7398(wool);
			spreader.paddingColor = null;
			spreader.method_5431();

			world.method_8396(player, pos, BotaniaSounds.spreaderUncover, class_3419.field_15245, 1F, 1F);

			return class_1269.method_29236(world.method_8608());
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 tile = world.method_8321(pos);
			if (!(tile instanceof ManaSpreaderBlockEntity spreader)) {
				return;
			}

			if (spreader.paddingColor != null) {
				class_1799 padding = new class_1799(ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
				class_1264.method_5449(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), padding);
			}

			if (state.method_11654(BotaniaStateProperties.HAS_SCAFFOLDING)) {
				class_1799 scaffolding = new class_1799(class_1802.field_16482);
				class_1264.method_5449(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), scaffolding);
			}

			class_1264.method_5451(world, pos, spreader.getItemHandler());

			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new ManaSpreaderBlockEntity(pos, state);
	}

	@org.jetbrains.annotations.Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.SPREADER, ManaSpreaderBlockEntity::commonTick);
	}
}
