/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;

public class ManaPumpBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 X_SHAPE = method_9541(0, 0, 4, 16, 8, 12);
	private static final class_265 Z_SHAPE = method_9541(4, 0, 0, 12, 8, 16);

	public ManaPumpBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11035));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12481);
	}

	@NotNull
	@Override
	public class_2680 method_9605(class_1750 context) {
		return super.method_9605(context).method_11657(class_2741.field_12481, context.method_8042().method_10153());
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		if (state.method_11654(class_2741.field_12481).method_10166() == class_2350.class_2351.field_11048) {
			return X_SHAPE;
		} else {
			return Z_SHAPE;
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return ((ManaPumpBlockEntity) world.method_8321(pos)).comparator;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new ManaPumpBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.PUMP, ManaPumpBlockEntity::commonTick);
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		if (world.method_8479(pos)) {
			ManaPrismBlock.redstoneParticlesInShape(state, world, pos, rand);
		}
	}
}
