/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPrismBlockEntity;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class ManaPrismBlock extends BotaniaWaterloggedBlock implements class_2343, ManaCollisionGhost {
	private static final class_265 SHAPE = method_9541(4, 0, 4, 12, 16, 12);

	public ManaPrismBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564()
				.method_11657(class_2741.field_12484, false)
				.method_11657(BotaniaStateProperties.HAS_LENS, false));
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@NotNull
	@Override
	public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
		if (context instanceof class_3727 econtext
				&& econtext.method_32480() instanceof ManaBurstEntity) {
			// Expose the shape so bursts can actually collide with us
			// they will still go through the prism via ManaCollisionGhost
			return SHAPE;
		} else {
			return super.method_9549(state, world, pos, context);
		}
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		if (state.method_11654(class_2741.field_12484)) {
			redstoneParticlesInShape(state, world, pos, rand);
		}
	}

	public static void redstoneParticlesInShape(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		if (rand.method_43056()) {
			class_238 localBox = state.method_26218(world, pos).method_1107();
			double x = pos.method_10263() + localBox.field_1323 + rand.method_43058() * (localBox.field_1320 - localBox.field_1323);
			double y = pos.method_10264() + localBox.field_1322 + rand.method_43058() * (localBox.field_1325 - localBox.field_1322);
			double z = pos.method_10260() + localBox.field_1321 + rand.method_43058() * (localBox.field_1324 - localBox.field_1321);
			world.method_8406(class_2390.field_11188, x, y, z, 0, 0, 0);
		}
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484, BotaniaStateProperties.HAS_LENS);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_2586 tile = world.method_8321(pos);
		if (!(tile instanceof ManaPrismBlockEntity prism)) {
			return class_1269.field_5811;
		}

		class_1799 lens = prism.getItemHandler().method_5438(0);
		class_1799 heldItem = player.method_5998(hand);
		boolean playerHasLens = !heldItem.method_7960() && heldItem.method_7909() instanceof BasicLensItem;
		boolean lensIsSame = playerHasLens && class_1799.method_31577(heldItem, lens);
		boolean mainHandEmpty = player.method_6047().method_7960();

		if (playerHasLens && !lensIsSame) {
			class_1799 toInsert = heldItem.method_7971(1);

			if (!lens.method_7960()) {
				player.method_31548().method_7398(lens);
			}

			prism.getItemHandler().method_5447(0, toInsert);
			world.method_8396(player, pos, BotaniaSounds.prismAddLens, class_3419.field_15245, 1F, 1F);
			return class_1269.method_29236(world.method_8608());
		}
		if (!lens.method_7960() && (mainHandEmpty || lensIsSame)) {
			player.method_31548().method_7398(lens);
			prism.getItemHandler().method_5447(0, class_1799.field_8037);

			world.method_8396(player, pos, BotaniaSounds.prismRemoveLens, class_3419.field_15245, 1F, 1F);

			return class_1269.method_29236(world.method_8608());
		}
		return class_1269.field_5811;
	}

	@Override
	public class_2680 method_9605(class_1750 context) {
		class_1937 world = context.method_8045();
		class_2338 pos = context.method_8037();
		boolean power = world.method_8482(pos) > 0;
		return super.method_9605(context).method_11657(class_2741.field_12484, power);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_8482(pos) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (!world.field_9236) {
			if (power && !powered) {
				world.method_8501(pos, state.method_11657(class_2741.field_12484, true));
			} else if (!power && powered) {
				world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
			}
		}
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof SimpleInventoryBlockEntity inventory) {
				class_1264.method_5451(world, pos, inventory.getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new ManaPrismBlockEntity(pos, state);
	}

	@Override
	public Behaviour getGhostBehaviour() {
		return Behaviour.RUN_RECEIVER_TRIGGER;
	}
}
