/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.HornItem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_5147;

public class DrumBlock extends BotaniaWaterloggedBlock {

	public enum Variant {
		WILD,
		GATHERING,
		CANOPY
	}

	private static final class_265 SHAPE = class_2248.method_9541(3, 1, 3, 13, 15, 13);
	private final Variant variant;

	public DrumBlock(Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	private static void convertNearby(class_1297 entity, class_1792 from, class_1792 to) {
		class_1937 world = entity.field_6002;
		List<class_1542> items = world.method_18467(class_1542.class, entity.method_5829());
		for (class_1542 item : items) {
			class_1799 itemstack = item.method_6983();
			if (!itemstack.method_7960() && itemstack.method_31574(from) && !world.field_9236) {
				while (itemstack.method_7947() > 0) {
					class_1542 ent = entity.method_5699(new class_1799(to), 1.0F);
					ent.method_18799(ent.method_18798().method_1031(
							world.field_9229.method_43057() * 0.05F,
							(world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.1F,
							(world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.1F
					));
					itemstack.method_7934(1);
				}
				item.method_31472();
			}
		}
	}

	public static class ManaTriggerImpl implements ManaTrigger {
		private final class_1937 world;
		private final class_2338 pos;
		private final Variant variant;

		public ManaTriggerImpl(class_1937 world, class_2338 pos, class_2680 state) {
			this.world = world;
			this.pos = pos;
			this.variant = ((DrumBlock) state.method_26204()).variant;
		}

		@Override
		public void onBurstCollision(ManaBurst burst) {
			if (burst.isFake()) {
				return;
			}
			if (world.field_9236) {
				world.method_8406(class_2398.field_11224, pos.method_10263() + 0.5, pos.method_10264() + 1.2, pos.method_10260() + 0.5D, 1.0 / 24.0, 0, 0);
				return;
			}
			if (variant == Variant.WILD) {
				HornItem.breakGrass(world, new class_1799(BotaniaItems.grassHorn), pos, null);
			} else if (variant == Variant.CANOPY) {
				HornItem.breakGrass(world, new class_1799(BotaniaItems.leavesHorn), pos, null);
			} else {
				int range = 10;
				List<class_1308> entities = world.method_8390(class_1308.class, new class_238(pos.method_10069(-range, -range, -range), pos.method_10069(range + 1, range + 1, range + 1)), e -> !BergamuteBlockEntity.isBergamuteNearby(world, e.method_23317(), e.method_23318(), e.method_23321()));
				List<class_1308> shearables = new ArrayList<>();

				for (class_1308 entity : entities) {
					if (entity instanceof class_1430) {
						convertNearby(entity, class_1802.field_8550, class_1802.field_8103);
						if (entity instanceof class_1438) {
							convertNearby(entity, class_1802.field_8428, class_1802.field_8208);
						}
					} else if (entity instanceof class_5147 shearable && shearable.method_27072()) {
						shearables.add(entity);
					}
				}

				Collections.shuffle(shearables);
				int sheared = 0;

				for (class_1308 entity : shearables) {
					if (sheared > 4) {
						break;
					}

					if (entity instanceof class_5147 shearable) {
						shearable.method_6636(class_3419.field_15245);
					}

					++sheared;
				}
			}

			for (int i = 0; i < 10; i++) {
				world.method_8396(null, pos, BotaniaSounds.drum, class_3419.field_15245, 1F, 1F);
			}
		}
	}
}
