/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class HydroangeasBlockEntity extends FluidGeneratorBlockEntity {
	public static final String TAG_PASSIVE_DECAY_TICKS = "passiveDecayTicks";

	private static final class_2338[] OFFSETS = { new class_2338(0, 0, 1), new class_2338(0, 0, -1), new class_2338(1, 0, 0), new class_2338(-1, 0, 0), new class_2338(-1, 0, 1), new class_2338(-1, 0, -1), new class_2338(1, 0, 1), new class_2338(1, 0, -1) };

	public static final int DECAY_TIME = 72000;

	private int passiveDecayTicks;

	public HydroangeasBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.HYDROANGEAS, pos, state, class_3486.field_15517, 40, 1, 0);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236) {
			if (++passiveDecayTicks > DECAY_TIME) {
				method_10997().method_22352(method_11016(), false);
				if (class_2246.field_10428.method_9564().method_26184(method_10997(), method_11016())) {
					method_10997().method_8501(method_11016(), class_2246.field_10428.method_9564());
				}
			}
		}
	}

	@Override
	public void doBurnParticles() {
		WispParticleData data = WispParticleData.wisp((float) Math.random() / 6, 0.05F, 0.05F, 0.7F, 1);
		emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.55 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0, (float) Math.random() / 60, 0);
	}

	@Override
	public void playSound() {
		//Usage of vanilla sound event: Subtitle is "Sipping", generic sounds are meant to be reused.
		method_10997().method_8396(null, getEffectivePos(), class_3417.field_20613, class_3419.field_15245, 0.01F, 0.5F + (float) Math.random() * 0.5F);
	}

	@Override
	public int getMaxMana() {
		return 150;
	}

	@Override
	public int getColor() {
		return 0x532FE0;
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		passiveDecayTicks = cmp.method_10550(TAG_PASSIVE_DECAY_TICKS);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_PASSIVE_DECAY_TICKS, passiveDecayTicks);
	}

	@Override
	public int getGenerationDelay() {
		boolean rain = method_10997().method_23753(getEffectivePos()).comp_349().method_8694() == class_1959.class_1963.field_9382
				&& (method_10997().method_8419() || method_10997().method_8546());
		return rain ? 2 : 3;
	}

	@Override
	public boolean isOvergrowthAffected() {
		return false;
	}
}
