/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_2246;
import net.minecraft.class_2313;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2490;
import net.minecraft.class_2586;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4622;

public class EntropinnyumBlockEntity extends GeneratingFlowerBlockEntity {
	private static final int RANGE = 12;
	private static final int EXPLODE_EFFECT_EVENT = 0;
	private static final int ANGRY_EFFECT_EVENT = 1;

	public EntropinnyumBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.ENTROPINNYUM, pos, state);
	}

	public static boolean isUnethical(class_1297 e) {
		class_2338 center = e.method_24515();
		if (!e.field_6002.method_8477(center)) {
			return false;
		}

		int x = center.method_10263();
		int y = center.method_10264();
		int z = center.method_10260();
		int range = 3;

		// Should actually check for corals too, but it gets broken when the piston extends
		int movingPistons = 0;
		int rails = 0;
		int slimes = 0;
		for (class_2338 pos : class_2338.method_10094(x - range, y - range, z - range, x + range + 1, y + range + 1, z + range + 1)) {
			class_2680 state = e.field_6002.method_8320(pos);
			if (state.method_27852(class_2246.field_10008)) {
				movingPistons++;
				class_2586 te = e.field_6002.method_8321(pos);
				if (te instanceof class_2669 piston) {
					state = piston.method_11495();
				}
			}

			if (state.method_26204() instanceof class_2313) {
				rails++;
			} else if (state.method_26204() instanceof class_2490 || state.method_26204() instanceof class_4622) {
				slimes++;
			}

			if (movingPistons > 0 && rails > 0 && slimes > 0) {
				return true;
			}
		}

		return false;
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236 && getMana() == 0) {
			List<class_1541> tnts = method_10997().method_18467(class_1541.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
			for (class_1541 tnt : tnts) {
				class_3610 fluid = method_10997().method_8316(tnt.method_24515());
				if (tnt.method_6969() == 1 && tnt.method_5805() && fluid.method_15769()) {
					boolean unethical = XplatAbstractions.INSTANCE.ethicalComponent(tnt).isUnethical();
					tnt.method_5783(unethical ? BotaniaSounds.entropinnyumAngry : BotaniaSounds.entropinnyumHappy, 1F, (1F + (method_10997().field_9229.method_43057() - method_10997().field_9229.method_43057()) * 0.2F) * 0.7F);
					tnt.method_31472();
					addMana(unethical ? 3 : getMaxMana());
					sync();

					method_10997().method_8427(method_11016(), method_11010().method_26204(), unethical ? ANGRY_EFFECT_EVENT : EXPLODE_EFFECT_EVENT, tnt.method_5628());
					break;
				}
			}
		}
	}

	@Override
	public boolean method_11004(int event, int param) {
		if (event == EXPLODE_EFFECT_EVENT) {
			if (method_10997().field_9236 && method_10997().method_8469(param) instanceof class_1541) {
				class_1297 e = method_10997().method_8469(param);

				for (int i = 0; i < 50; i++) {
					SparkleParticleData data = SparkleParticleData.sparkle((float) (Math.random() * 0.65F + 1.25F), 1F, (float) Math.random() * 0.25F, (float) Math.random() * 0.25F, 12);
					field_11863.method_8406(data, e.method_23317() + Math.random() * 4 - 2, e.method_23318() + Math.random() * 4 - 2, e.method_23321() + Math.random() * 4 - 2, 0, 0, 0);
				}

				method_10997().method_8406(class_2398.field_11221, e.method_23317(), e.method_23318(), e.method_23321(), 1D, 0D, 0D);
			}
			return true;
		} else if (event == ANGRY_EFFECT_EVENT) {
			if (method_10997().field_9236 && method_10997().method_8469(param) instanceof class_1541) {
				class_1297 e = method_10997().method_8469(param);

				for (int i = 0; i < 50; i++) {
					field_11863.method_8406(class_2398.field_11231, e.method_23317() + Math.random() * 4 - 2, e.method_23318() + Math.random() * 4 - 2, e.method_23321() + Math.random() * 4 - 2, 0, 0, 0);
				}
			}

			return true;
		} else {
			return super.method_11004(event, param);
		}
	}

	@Override
	public int getColor() {
		return 0xcb0000;
	}

	@Override
	public int getMaxMana() {
		return 6500;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

}
