/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class EndoflameBlockEntity extends GeneratingFlowerBlockEntity {
	private static final String TAG_BURN_TIME = "burnTime";
	private static final int FUEL_CAP = 32000;
	private static final int RANGE = 3;
	private static final int START_BURN_EVENT = 0;

	private int burnTime = 0;

	public EndoflameBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.ENDOFLAME, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (burnTime > 0) {
			burnTime--;
		}

		if (method_10997().field_9236) {
			if (burnTime > 0 && method_10997().field_9229.method_43048(10) == 0) {
				emitParticle(class_2398.field_11240, 0.4 + Math.random() * 0.2, 0.7, 0.4 + Math.random() * 0.2, 0.0D, 0.0D, 0.0D);
			}
			return;
		} else {
			if (burnTime > 0 && ticksExisted % 2 == 0) {
				addMana(3);
			}
		}

		if (burnTime == 0) {
			if (getMana() < getMaxMana()) {

				for (class_1542 item : method_10997().method_18467(class_1542.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)))) {
					if (DelayHelper.canInteractWith(this, item)) {
						class_1799 stack = item.method_6983();
						if (stack.method_7909().method_7857()) {
							continue;
						}

						int burnTime = getBurnTime(stack);
						if (burnTime > 0 && stack.method_7947() > 0) {
							this.burnTime = Math.min(FUEL_CAP, burnTime) / 2;

							EntityHelper.shrinkItem(item);
							method_10997().method_8396(null, getEffectivePos(), BotaniaSounds.endoflame, class_3419.field_15245, 1F, 1F);
							method_10997().method_8427(method_11016(), method_11010().method_26204(), START_BURN_EVENT, item.method_5628());
							sync();

							return;
						}
					}
				}
			}
		}
	}

	@Override
	public boolean method_11004(int event, int param) {
		if (event == START_BURN_EVENT) {
			class_1297 e = method_10997().method_8469(param);
			if (e != null) {
				e.field_6002.method_8406(class_2398.field_11237, e.method_23317(), e.method_23318() + 0.1, e.method_23321(), 0.0D, 0.0D, 0.0D);
				e.field_6002.method_8406(class_2398.field_11240, e.method_23317(), e.method_23318(), e.method_23321(), 0.0D, 0.0D, 0.0D);
			}
			return true;
		} else {
			return super.method_11004(event, param);
		}
	}

	@Override
	public int getMaxMana() {
		return 300;
	}

	@Override
	public int getColor() {
		return 0x785000;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_BURN_TIME, burnTime);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		burnTime = cmp.method_10550(TAG_BURN_TIME);
	}

	private int getBurnTime(class_1799 stack) {
		if (stack.method_7960() || class_2248.method_9503(stack.method_7909()) instanceof ManaSpreaderBlock) {
			return 0;
		} else {
			return XplatAbstractions.INSTANCE.getSmeltingBurnTime(stack);
		}
	}

}
