/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.MathHelper;

import java.util.*;
import net.minecraft.class_1560;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class VinculotusBlockEntity extends FunctionalFlowerBlockEntity {
	public static final Set<VinculotusBlockEntity> existingFlowers = Collections.newSetFromMap(new WeakHashMap<>());
	private static final int RANGE = 64;

	public VinculotusBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.VINCULOTUS, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236) {
			existingFlowers.add(this);
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), RANGE);
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0x0A6051;
	}

	@Override
	public int getMaxMana() {
		return 500;
	}

	@Nullable
	public static class_243 onEndermanTeleport(class_1560 entity, double targetX, double targetY, double targetZ) {
		int cost = 50;

		List<VinculotusBlockEntity> possibleFlowers = new ArrayList<>();
		for (VinculotusBlockEntity flower : existingFlowers) {
			class_2338 activePos = flower.getEffectivePos();

			if (flower.redstoneSignal > 0 || flower.getMana() <= cost
					|| flower.method_10997() != entity.field_6002
					|| flower.method_10997().method_8321(flower.method_11016()) != flower) {
				continue;
			}

			double x = activePos.method_10263() + 0.5;
			double y = activePos.method_10264() + 1.5;
			double z = activePos.method_10260() + 0.5;

			if (MathHelper.pointDistanceSpace(x, y, z, targetX, targetY, targetZ) < RANGE) {
				possibleFlowers.add(flower);
			}
		}

		if (!possibleFlowers.isEmpty()) {
			VinculotusBlockEntity flower = possibleFlowers.get(entity.field_6002.field_9229.method_43048(possibleFlowers.size()));
			class_2338 activePos = flower.getEffectivePos();

			double x = activePos.method_10263() + 0.5;
			double y = activePos.method_10264() + 1.5;
			double z = activePos.method_10260() + 0.5;

			flower.addMana(-cost);
			flower.sync();

			return new class_243(x + Math.random() * 3 - 1, y, z + Math.random() * 3 - 1);
		}

		return null;
	}
}
