/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.item.FlowerPlaceable;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.*;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_6088;

public class RannuncarpusBlockEntity extends FunctionalFlowerBlockEntity implements Wandable {
	private static final int PICKUP_RANGE = 2;
	private static final int PICKUP_RANGE_Y = 3;
	private static final int RANGE_PLACE_MANA = 8;
	private static final int RANGE_PLACE = 6;
	private static final int RANGE_PLACE_Y = 6;

	private static final int RANGE_PLACE_MANA_MINI = 3;
	private static final int RANGE_PLACE_MINI = 2;
	private static final int RANGE_PLACE_Y_MINI = 2;
	private static final String TAG_STATE_SENSITIVE = "stateSensitive";
	private boolean stateSensitive = false;

	protected RannuncarpusBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	public RannuncarpusBlockEntity(class_2338 pos, class_2680 state) {
		this(BotaniaFlowerBlocks.RANNUNCARPUS, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		if (ticksExisted % 10 == 0) {
			List<class_1542> items = method_10997().method_18467(class_1542.class, new class_238(method_11016().method_10069(-PICKUP_RANGE, -PICKUP_RANGE_Y, -PICKUP_RANGE), method_11016().method_10069(PICKUP_RANGE + 1, PICKUP_RANGE_Y + 1, PICKUP_RANGE + 1)));

			List<class_1799> filter = HopperhockBlockEntity.getFilterForInventory(method_10997(), getFilterPos(), false);

			for (class_1542 item : items) {
				if (!DelayHelper.canInteractWith(this, item)) {
					continue;
				}

				class_1799 stack = item.method_6983();
				if (!HopperhockBlockEntity.canAcceptItem(stack, filter, 0)) {
					continue;
				}

				class_1792 stackItem = stack.method_7909();
				class_2960 id = class_2378.field_11142.method_10221(stackItem);
				if (BotaniaConfig.common().rannuncarpusModBlacklist().contains(id.method_12836())
						|| BotaniaConfig.common().rannuncarpusItemBlacklist().contains(id.toString())) {
					continue;
				}

				if (stackItem instanceof class_1747 || stackItem instanceof FlowerPlaceable) {
					class_2338 coords = getCandidatePosition(method_10997().field_9229);
					if (coords == null) {
						continue;
					}
					class_3965 ray = new class_3965(new class_243(coords.method_10263() + 0.5, coords.method_10264() + 1, coords.method_10260() + 0.5), class_2350.field_11036, coords, false);
					class_1750 ctx = new RannuncarpusPlaceContext(method_10997(), stack, ray, field_11867);

					boolean success = false;
					if (stackItem instanceof FlowerPlaceable flowerPlaceable) {
						success = flowerPlaceable.tryPlace(this, ctx);
					}
					if (!success && stackItem instanceof class_1747 blockItem) {
						success = blockItem.method_7712(ctx).method_23665();
					}

					if (success) {
						if (BotaniaConfig.common().blockBreakParticles()) {
							class_2680 state = method_10997().method_8320(ctx.method_8037());
							method_10997().method_20290(class_6088.field_31144, coords, class_2248.method_9507(state));
						}
						if (getMana() > 1) {
							addMana(-1);
						}
						EntityHelper.syncItem(item);
						return;
					}
				}
			}
		}
	}

	private class_2338 getFilterPos() {
		return method_11016().method_10087(isFloating() ? 1 : 2);
	}

	public class_2680 getUnderlyingBlock() {
		return method_10997().method_8320(getFilterPos());
	}

	@Nullable
	private class_2338 getCandidatePosition(class_5819 rand) {
		int rangePlace = getPlaceRange();
		int rangePlaceY = getVerticalPlaceRange();
		class_2338 center = getEffectivePos();
		class_2680 filter = getUnderlyingBlock();
		List<class_2338> ret = new ArrayList<>();

		for (class_2338 pos : class_2338.method_10097(center.method_10069(-rangePlace, -rangePlaceY, -rangePlace),
				center.method_10069(rangePlace, rangePlaceY, rangePlace))) {
			class_2680 state = method_10997().method_8320(pos);
			class_2680 up = method_10997().method_8320(pos.method_10084());

			boolean matches;
			if (stateSensitive) {
				matches = state == filter;
			} else {
				matches = state.method_27852(filter.method_26204());
			}

			if (matches && (up.method_26215() || up.method_26207().method_15800())) {
				ret.add(pos.method_10062());
			}
		}

		return ret.isEmpty() ? null : ret.get(rand.method_43048(ret.size()));
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		if (cmp.method_10545(TAG_STATE_SENSITIVE)) {
			stateSensitive = cmp.method_10577(TAG_STATE_SENSITIVE);
		} else {
			// old flowers stay state sensitive, new flowers are state insensitive
			stateSensitive = true;
		}
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10556(TAG_STATE_SENSITIVE, stateSensitive);
	}

	@Override
	public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
		if (player == null || player.method_5715()) {
			stateSensitive = !stateSensitive;
			method_5431();
			sync();
			return true;
		}
		return false;
	}

	public static class WandHud extends FunctionalWandHud<RannuncarpusBlockEntity> {
		public WandHud(RannuncarpusBlockEntity flower) {
			super(flower);
		}

		@Override
		public void renderHUD(class_4587 ms, class_310 mc) {
			super.renderHUD(ms, mc);

			class_2680 filter = flower.getUnderlyingBlock();
			class_1799 recieverStack = new class_1799(filter.method_26204());
			int color = flower.getColor();

			if (!recieverStack.method_7960()) {
				class_2561 stackName = recieverStack.method_7964();
				int width = 16 + mc.field_1772.method_27525(stackName) / 2;
				int x = mc.method_22683().method_4486() / 2 - width;
				int y = mc.method_22683().method_4502() / 2 + 30;

				mc.field_1772.method_30881(ms, stackName, x + 20, y + 5, color);
				mc.method_1480().method_4023(recieverStack, x, y);

				String mode = class_1074.method_4662("botaniamisc.rannuncarpus." + (flower.stateSensitive ? "state_sensitive" : "state_insensitive"));
				x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(mode) / 2;
				y = mc.method_22683().method_4502() / 2 + 50;
				mc.field_1772.method_1720(ms, mode, x, y, class_124.field_1068.method_532());
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), getPlaceRange());
	}

	@Override
	public RadiusDescriptor getSecondaryRadius() {
		if (getPlaceRange() == PICKUP_RANGE && getEffectivePos().equals(method_11016())) {
			return null;
		}
		return RadiusDescriptor.Rectangle.square(method_11016(), PICKUP_RANGE);
	}

	public int getPlaceRange() {
		return getMana() > 0 ? RANGE_PLACE_MANA : RANGE_PLACE;
	}

	public int getVerticalPlaceRange() {
		return RANGE_PLACE_Y;
	}

	@Override
	public int getMaxMana() {
		return 20;
	}

	@Override
	public int getColor() {
		return 0xFFB27F;
	}

	public static class Mini extends RannuncarpusBlockEntity {
		public Mini(class_2338 pos, class_2680 state) {
			super(BotaniaFlowerBlocks.RANNUNCARPUS_CHIBI, pos, state);
		}

		@Override
		public int getPlaceRange() {
			return getMana() > 0 ? RANGE_PLACE_MANA_MINI : RANGE_PLACE_MINI;
		}

		@Override
		public int getVerticalPlaceRange() {
			return RANGE_PLACE_Y_MINI;
		}
	}

	// BlockItemUseContext uses a nullable player field without checking it -.-
	private static class RannuncarpusPlaceContext extends class_1750 {
		private final class_2350[] lookDirs;
		private final float placementYaw;

		public RannuncarpusPlaceContext(class_1937 world, class_1799 stack, class_3965 rtr, class_2338 flowerPos) {
			super(world, null, class_1268.field_5808, stack, rtr);
			int dx = rtr.method_17777().method_10263() - flowerPos.method_10263();
			int dy = rtr.method_17777().method_10264() - flowerPos.method_10264();
			int dz = rtr.method_17777().method_10260() - flowerPos.method_10260();

			class_2350 xClosest = dx >= 0 ? class_2350.field_11034 : class_2350.field_11039;
			class_2350 yClosest = dy >= 0 ? class_2350.field_11036 : class_2350.field_11033;
			class_2350 zClosest = dz >= 0 ? class_2350.field_11035 : class_2350.field_11043;

			List<class_2350> directions = sortThree(xClosest, yClosest, zClosest, Math.abs(dx), Math.abs(dy), Math.abs(dz));

			class_2350 first = directions.get(0);
			class_2350 second = directions.get(1);
			class_2350 third = directions.get(2);

			lookDirs = new class_2350[] {
					first,
					second,
					third,
					third.method_10153(),
					second.method_10153(),
					first.method_10153()
			};

			placementYaw = (float) (-class_3532.method_15349(dx, dz) * 180 / Math.PI);
		}

		/**
		 * Arrange a, b and c such that their corresponding ints (a -> aInt) are in descending order.
		 */
		private static <T> List<T> sortThree(T a, T b, T c, int aInt, int bInt, int cInt) {
			if (aInt >= bInt) {
				if (bInt >= cInt) {
					return ImmutableList.of(a, b, c);
				} else {
					return cInt >= aInt ? ImmutableList.of(c, a, b) : ImmutableList.of(a, c, b);
				}
			} else if (bInt >= cInt) {
				return cInt >= aInt ? ImmutableList.of(b, c, a) : ImmutableList.of(b, a, c);
			} else {
				return ImmutableList.of(c, b, a);
			}
		}

		@NotNull
		@Override
		public class_2350 method_7715() {
			return method_7718()[0];
		}

		@NotNull
		@Override
		public class_2350[] method_7718() {
			return lookDirs;
		}

		@NotNull
		@Override
		public class_2350 method_8042() {
			return method_7715().method_10166().method_10179() ? method_7715() : method_7718()[1];
		}

		@Override
		public float method_8044() {
			return placementYaw;
		}
	}

}
