/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;

import java.util.List;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_6024;

public class PollidisiacBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int RANGE = 6;
	private static final int MANA_COST = 12;

	public PollidisiacBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.POLLIDISIAC, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236) {
			var pickupBounds = new class_238(method_11016().method_10069(-RANGE, -RANGE, -RANGE), method_11016().method_10069(RANGE + 1, RANGE + 1, RANGE + 1));
			List<class_1542> items = method_10997().method_18467(class_1542.class, pickupBounds);
			var bounds = new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1));
			List<class_1429> animals = method_10997().method_18467(class_1429.class, bounds);

			for (class_1429 animal : animals) {
				if (getMana() < MANA_COST) {
					break;
				}

				if (animal.method_5618() == 0 && !animal.method_6479()) {
					for (class_1542 item : items) {
						if (!DelayHelper.canInteractWith(this, item)) {
							continue;
						}

						if (animal.method_6481(item.method_6983())) {
							EntityHelper.shrinkItem(item);

							addMana(-MANA_COST);
							animal.method_6476(1200);
							method_10997().method_8421(animal, class_6024.field_30043);
							break;
						}
					}
				}
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public RadiusDescriptor getSecondaryRadius() {
		return method_11016().equals(getEffectivePos()) ? null : RadiusDescriptor.Rectangle.square(method_11016(), RANGE);
	}

	@Override
	public int getMaxMana() {
		return 120;
	}

	@Override
	public int getColor() {
		return 0xCF4919;
	}

}
