/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_6088;

public class ClayconiaBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int COST = 80;
	private static final int RANGE = 5;
	private static final int RANGE_Y = 3;

	private static final int RANGE_MINI = 2;
	private static final int RANGE_Y_MINI = 1;

	protected ClayconiaBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	public ClayconiaBlockEntity(class_2338 pos, class_2680 state) {
		this(BotaniaFlowerBlocks.CLAYCONIA, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236 && ticksExisted % 5 == 0) {
			if (getMana() >= COST) {
				class_2338 coords = getCoordsToPut();
				if (coords != null) {
					int stateId = class_2248.method_9507(method_10997().method_8320(coords));
					method_10997().method_8650(coords, false);
					if (BotaniaConfig.common().blockBreakParticles()) {
						method_10997().method_20290(class_6088.field_31144, coords, stateId);
					}
					class_1542 item = new class_1542(method_10997(), coords.method_10263() + 0.5, coords.method_10264() + 0.5, coords.method_10260() + 0.5, new class_1799(class_1802.field_8696));
					method_10997().method_8649(item);
					addMana(-COST);
				}
			}
		}
	}

	public class_2338 getCoordsToPut() {
		List<class_2338> possibleCoords = new ArrayList<>();

		int range = getRange();
		int rangeY = getRangeY();

		for (int i = -range; i < range + 1; i++) {
			for (int j = -rangeY; j < rangeY + 1; j++) {
				for (int k = -range; k < range + 1; k++) {
					class_2338 pos = getEffectivePos().method_10069(i, j, k);
					class_2680 state = method_10997().method_8320(pos);
					if (state.method_26164(class_3481.field_15466)) {
						possibleCoords.add(pos);
					}
				}
			}
		}

		if (possibleCoords.isEmpty()) {
			return null;
		}
		return possibleCoords.get(method_10997().field_9229.method_43048(possibleCoords.size()));
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), getRange());
	}

	public int getRange() {
		return RANGE;
	}

	public int getRangeY() {
		return RANGE_Y;
	}

	@Override
	public int getColor() {
		return 0x7B8792;
	}

	@Override
	public int getMaxMana() {
		return 640;
	}

	public static class Mini extends ClayconiaBlockEntity {
		public Mini(class_2338 pos, class_2680 state) {
			super(BotaniaFlowerBlocks.CLAYCONIA_CHIBI, pos, state);
		}

		@Override
		public int getRange() {
			return RANGE_MINI;
		}

		@Override
		public int getRangeY() {
			return RANGE_Y_MINI;
		}
	}
}
