/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.decor;

import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class BuriedPetalBlock extends class_2261 implements class_2256 {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 1.6, 16);

	public final class_1767 color;

	public BuriedPetalBlock(class_1767 color, class_2251 builder) {
		super(builder);
		this.color = color;
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		int hex = MysticalPetalItem.getPetalLikeColor(color);
		int r = (hex & 0xFF0000) >> 16;
		int g = (hex & 0xFF00) >> 8;
		int b = hex & 0xFF;

		SparkleParticleData data = SparkleParticleData.noClip(rand.method_43057(), r / 255F, g / 255F, b / 255F, 5);
		world.method_8406(data, pos.method_10263() + 0.3 + rand.method_43057() * 0.5, pos.method_10264() + 0.1 + rand.method_43057() * 0.1, pos.method_10260() + 0.3 + rand.method_43057() * 0.5, 0, 0, 0);
	}

	@NotNull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11455;
	}

	@Override
	public boolean method_9651(@NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_2680 state, boolean fuckifiknow) {
		return world.method_8320(pos.method_10084()).method_26215();
	}

	@Override
	public boolean method_9650(@NotNull class_1937 world, @NotNull class_5819 rand, @NotNull class_2338 pos, @NotNull class_2680 state) {
		return method_9651(world, pos, state, false);
	}

	@Override
	public void method_9652(@NotNull class_3218 world, @NotNull class_5819 rand, @NotNull class_2338 pos, @NotNull class_2680 state) {
		class_2248 block = BotaniaBlocks.getDoubleFlower(color);
		if (block instanceof class_2320) {
			class_2320.method_10021(world, block.method_9564(), pos, 3);
		}
	}
}
