/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.corporea;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaFunnelBlockEntity;

public class CorporeaFunnelBlock extends BotaniaBlock implements class_2343 {

	public CorporeaFunnelBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_8482(pos) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			world.method_8652(pos, state.method_11657(class_2741.field_12484, true), class_2248.field_31029);
			((CorporeaFunnelBlockEntity) world.method_8321(pos)).doRequest();
		} else if (!power && powered) {
			world.method_8652(pos, state.method_11657(class_2741.field_12484, false), class_2248.field_31029);
		}
	}

	@NotNull
	@Override
	public BaseCorporeaBlockEntity method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new CorporeaFunnelBlockEntity(pos, state);
	}

}
