/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;

public class ManaPrismBlockEntity extends ExposedSimpleInventoryBlockEntity implements ManaTrigger {
	public ManaPrismBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.PRISM, pos, state);
	}

	@Override
	public void onBurstCollision(ManaBurst burst) {
		class_1799 lens = getItemHandler().method_5438(0);
		boolean active = !method_11010().method_11654(class_2741.field_12484);
		boolean valid = !lens.method_7960() && lens.method_7909() instanceof BasicLensItem && (!(lens.method_7909() instanceof TinyPlanetExcempt excempt) || excempt.shouldPull(lens));

		if (active) {
			burst.setSourceLens(valid ? lens.method_7972() : class_1799.field_8037);
			burst.setColor(0xFFFFFF);
			burst.setGravity(0F);

			if (valid) {
				class_1297 burstEntity = burst.entity();
				BurstProperties properties = new BurstProperties(burst.getStartingMana(), burst.getMinManaLoss(), burst.getManaLossPerTick(), burst.getBurstGravity(), 1F, burst.getColor());

				((BasicLensItem) lens.method_7909()).apply(lens, properties, field_11863);

				burst.setColor(properties.color);
				burst.setStartingMana(properties.maxMana);
				burst.setMinManaLoss(properties.ticksBeforeManaLoss);
				burst.setManaLossPerTick(properties.manaLossPerTick);
				burst.setGravity(properties.gravity);
				burstEntity.method_18799(burstEntity.method_18798().method_1021(properties.motionModifier));
			}
		}
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(1) {
			@Override
			public boolean method_5437(int index, class_1799 stack) {
				return !stack.method_7960() && stack.method_7909() instanceof BasicLensItem;
			}

			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public void method_5431() {
		super.method_5431();
		if (field_11863 != null && !field_11863.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			class_2680 state = method_11010();
			boolean hasLens = !getItemHandler().method_5438(0).method_7960();
			if (!state.method_27852(BotaniaBlocks.prism) || state.method_11654(BotaniaStateProperties.HAS_LENS) != hasLens) {
				class_2680 base = state.method_27852(BotaniaBlocks.prism) ? state : BotaniaBlocks.prism.method_9564();
				field_11863.method_8501(field_11867, base.method_11657(BotaniaStateProperties.HAS_LENS, hasLens));
			}
		}
	}

	public static class WandHud implements WandHUD {
		private final ManaPrismBlockEntity prism;

		public WandHud(ManaPrismBlockEntity prism) {
			this.prism = prism;
		}

		@Override
		public void renderHUD(class_4587 ms, class_310 mc) {
			class_1799 lens = prism.method_5438(0);
			if (!lens.method_7960()) {
				class_2561 lensName = lens.method_7964();
				int width = 16 + mc.field_1772.method_27525(lensName) / 2;
				int x = mc.method_22683().method_4486() / 2 - width;
				int y = mc.method_22683().method_4502() / 2;

				mc.field_1772.method_30881(ms, lensName, x + 20, y + 5, -1);
				mc.method_1480().method_4023(lens, x, y);
			}
		}
	}

}
