/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3419;
import net.minecraft.class_3865;
import net.minecraft.class_3866;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.ExoflameFurnaceHandler;
import vazkii.botania.mixin.AbstractFurnaceBlockEntityAccessor;

public class BellowsBlockEntity extends BotaniaBlockEntity {
	private static final String TAG_ACTIVE = "active";

	public float movePos;
	public boolean active = false;
	public float moving = 0F;

	public BellowsBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.BELLOWS, pos, state);
	}

	public void interact() {
		if (moving == 0F) {
			setActive(true);
		}
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, BellowsBlockEntity self) {
		boolean disable = true;
		class_2586 tile = self.getLinkedTile();
		if (!self.active && tile instanceof ManaPoolBlockEntity pool) {
			boolean transfer = pool.isDoingTransfer;
			if (transfer) {
				if (pool.ticksDoingTransfer > 0) {
					self.setActive(true);
				}
				disable = false;
			}
		}

		float max = 0.9F;
		float min = 0F;

		float incr = max / 20F;

		if (self.movePos < max && self.active && self.moving >= 0F) {
			if (self.moving == 0F) {
				level.method_8396(null, worldPosition, BotaniaSounds.bellows, class_3419.field_15245, 1F, 1F);
			}

			if (tile instanceof class_2609 furnace) {
				if (ExoflameFurnaceHandler.canSmelt(furnace)) {
					AbstractFurnaceBlockEntityAccessor mFurnace = (AbstractFurnaceBlockEntityAccessor) furnace;
					mFurnace.setCookingProgress(Math.min(mFurnace.getCookingTotalTime() - 1, mFurnace.getCookingProgress() + 20));
					mFurnace.setLitTime(Math.max(0, mFurnace.getLitTime() - 10));
				}

				if (furnace instanceof class_3866
						&& furnace.method_11002() && furnace.method_11010().method_11654(class_3865.field_11105)) {
					// [VanillaCopy] FurnaceBlock
					double d0 = (double) worldPosition.method_10263() + 0.5D;
					double d1 = (double) worldPosition.method_10264();
					double d2 = (double) worldPosition.method_10260() + 0.5D;
					// Botania: no playSound

					class_2350 enumfacing = furnace.method_11010().method_11654(class_3865.field_11104);
					class_2350.class_2351 enumfacing$axis = enumfacing.method_10166();
					double d3 = 0.52D;
					double d4 = level.field_9229.method_43058() * 0.6D - 0.3D;
					double d5 = enumfacing$axis == class_2350.class_2351.field_11048 ? (double) enumfacing.method_10148() * 0.52D : d4;
					double d6 = level.field_9229.method_43058() * 6.0D / 16.0D;
					double d7 = enumfacing$axis == class_2350.class_2351.field_11051 ? (double) enumfacing.method_10165() * 0.52D : d4;
					level.method_8406(class_2398.field_11251, d0 + d5, d1 + d6, d2 + d7, 0.0D, 0.0D, 0.0D);
					level.method_8406(class_2398.field_11240, d0 + d5, d1 + d6, d2 + d7, 0.0D, 0.0D, 0.0D);
				}
			}

			self.movePos += incr * 3;
			self.moving = incr * 3;
			if (self.movePos >= max) {
				self.movePos = Math.min(max, self.movePos);
				self.moving = 0F;
				if (disable) {
					self.setActive(false);
				}
			}
		} else if (self.movePos > min) {
			self.movePos -= incr;
			self.moving = -incr;
			if (self.movePos <= min) {
				self.movePos = Math.max(min, self.movePos);
				self.moving = 0F;
			}
		}

	}

	public class_2586 getLinkedTile() {
		class_2350 side = method_11010().method_11654(class_2741.field_12481);
		return field_11863.method_8321(method_11016().method_10093(side));
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10556(TAG_ACTIVE, active);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		active = cmp.method_10577(TAG_ACTIVE);
	}

	public void setActive(boolean active) {
		if (!field_11863.field_9236) {
			boolean diff = this.active != active;
			this.active = active;
			if (diff) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		}
	}

}
